/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.env.processor;

import io.github.cdimascio.dotenv.Dotenv;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;

public class DotenvEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String dotenvPath = environment.getProperty("sun-rays.env.path");
        if (dotenvPath != null) {
            Dotenv dotenv = Dotenv.configure().directory(dotenvPath).filename(".env").load();
            dotenv.entries().forEach(entry -> environment.getSystemProperties().put(entry.getKey(), entry.getValue()));
            System.out.println("Loaded .env from path: " + dotenvPath);
        } else {
            System.err.println("sun-rays.env.path not configured\uff01");
        }
    }
}

