/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.exception;

import cn.sunxiansheng.exception.CustomException;
import cn.sunxiansheng.tool.response.ResultWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultWrapper<Object> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        String message = ((ObjectError)e.getAllErrors().get(0)).getDefaultMessage();
        log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {} | \u5f02\u5e38\u8be6\u60c5: ", (Object)message, (Object)e);
        return ResultWrapper.fail((int)400, (String)message);
    }

    @ExceptionHandler(value={BindException.class})
    public ResultWrapper<Object> handleBindException(BindException e) {
        String message = ((ObjectError)e.getAllErrors().get(0)).getDefaultMessage();
        log.error("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25: {} | \u5f02\u5e38\u8be6\u60c5: ", (Object)message, (Object)e);
        return ResultWrapper.fail((int)400, (String)message);
    }

    @ExceptionHandler(value={CustomException.class})
    public ResultWrapper<Object> handleCustomException(CustomException e) {
        log.error("\u81ea\u5b9a\u4e49\u5f02\u5e38: {} | \u9519\u8bef\u7801: {} | \u5f02\u5e38\u8be6\u60c5: ", new Object[]{e.getErrorMessage(), e.getErrorCode(), e});
        return ResultWrapper.fail((int)e.getErrorCode(), (String)e.getErrorMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public ResultWrapper<Object> handleException(Exception e) {
        log.error("\u7cfb\u7edf\u5f02\u5e38: {} | \u5f02\u5e38\u8be6\u60c5: ", (Object)e.getMessage(), (Object)e);
        return ResultWrapper.fail((int)500, (String)"\u7cfb\u7edf\u5f02\u5e38");
    }
}

