/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.log4j2.aspectj;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_CYAN = "\u001b[92m";

    @Pointcut(value="execution(public * *..controller..*(..)) || execution(public * *..service..*(..))")
    public void applicationPackagePointcut() {
    }

    @Around(value="applicationPackagePointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String className = signature.getDeclaringTypeName();
        String methodName = signature.getName();
        Object[] args = joinPoint.getArgs();
        String requestParams = GSON.toJson((Object)args);
        log.info("==> \u8fdb\u5165\u65b9\u6cd5: {}.{}()", (Object)className, (Object)methodName);
        log.info("\u53c2\u6570:\n\u001b[92m{}\u001b[0m", (Object)requestParams);
        long startTime = System.currentTimeMillis();
        Object result = joinPoint.proceed();
        long endTime = System.currentTimeMillis();
        long executionTime = endTime - startTime;
        String response = GSON.toJson(result);
        log.info("<== \u9000\u51fa\u65b9\u6cd5: {}.{}() | \u8017\u65f6: {} ms", new Object[]{className, methodName, executionTime});
        log.info("\u8fd4\u56de\u503c:\n\u001b[92m{}\u001b[0m", (Object)response);
        return result;
    }
}

