/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.log4j2.aspectj;

import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class TraceIdLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(TraceIdLoggingAspect.class);
    private static final String GREEN = "\u001b[32m";
    private static final String RESET = "\u001b[0m";
    private static final int TOTAL_WIDTH = 150;
    @Autowired
    private Tracer tracer;

    @Pointcut(value="execution(public * *..controller..*(..))")
    public void controllerMethods() {
    }

    @Before(value="controllerMethods()")
    public void logRequest() {
        String traceId = null;
        try {
            traceId = this.tracer.currentSpan().context().traceId();
        }
        catch (Exception e) {
            log.warn("traceId \u4e3a\u7a7a\uff01");
        }
        String arrowWithTraceId = this.getArrowWithTraceId(traceId);
        log.info("\n" + arrowWithTraceId);
    }

    private String getArrowWithTraceId(String traceId) {
        int traceIdLength = traceId.length();
        int sideLength = (150 - traceIdLength) / 2;
        String sideArrow = this.generateArrow(sideLength);
        String topArrow = this.generateArrow(150);
        String middleArrow = sideArrow + traceId + sideArrow;
        String bottomArrow = this.generateArrow(150);
        return GREEN + topArrow + "\n" + middleArrow + "\n" + bottomArrow + RESET;
    }

    private String generateArrow(int length) {
        StringBuilder arrow = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            arrow.append('=');
        }
        return arrow.toString();
    }
}

