/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.log4j2.config;

import cn.sunxiansheng.log4j2.aspectj.LogAspect;
import cn.sunxiansheng.log4j2.aspectj.TraceIdLoggingAspect;
import cn.sunxiansheng.log4j2.config.properties.Log4j2Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={Log4j2Properties.class})
public class Log4j2AutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Log4j2AutoConfiguration.class);

    @PostConstruct
    public void logConfigSuccess() {
        log.info("Log4j2AutoConfiguration has been loaded successfully!");
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"sun-rays.log4j2.log-aspect-enable"}, havingValue="true", matchIfMissing=true)
    LogAspect logAspect() {
        log.info("LogAspect \u6210\u529f\u6ce8\u5165!");
        return new LogAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    TraceIdLoggingAspect traceIdLoggingAspect() {
        return new TraceIdLoggingAspect();
    }
}

