/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.log4j2.aspectj;

import cn.sunxiansheng.log4j2.annotation.SkipLogAspect;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_BLUE = "\u001b[34m";
    private static final String ANSI_PURPLE = "\u001b[35m";
    private static final String ANSI_CYAN = "\u001b[36m";

    @Pointcut(value="execution(public * *..controller..*(..)) || execution(public * *..service..*(..))")
    public void applicationPackagePointcut() {
    }

    @Around(value="applicationPackagePointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Class<?> targetClass = joinPoint.getTarget().getClass();
        if (method.isAnnotationPresent(SkipLogAspect.class) || targetClass.isAnnotationPresent(SkipLogAspect.class)) {
            return joinPoint.proceed();
        }
        String className = signature.getDeclaringTypeName();
        String methodName = signature.getName();
        Object[] args = joinPoint.getArgs();
        String requestParams = this.prettyJson(GSON.toJson((Object)args));
        long startTime = System.currentTimeMillis();
        StringBuilder enterLog = new StringBuilder();
        enterLog.append("\n").append(ANSI_GREEN).append("==> \u8fdb\u5165\u65b9\u6cd5 ").append(ANSI_RESET).append(ANSI_PURPLE).append(methodName).append(ANSI_RESET).append("\n").append(ANSI_BLUE).append("\u7c7b\u540d\uff1a").append(ANSI_CYAN).append(className).append(ANSI_RESET).append("\n").append(ANSI_BLUE).append("\u53c2\u6570\uff1a\n").append(ANSI_GREEN).append(requestParams).append(ANSI_RESET);
        log.info(enterLog.toString());
        Object result = joinPoint.proceed();
        long endTime = System.currentTimeMillis();
        String response = this.prettyJson(GSON.toJson(result));
        StringBuilder exitLog = new StringBuilder();
        exitLog.append("\n").append(ANSI_RED).append("<== \u9000\u51fa\u65b9\u6cd5 ").append(ANSI_RESET).append(ANSI_PURPLE).append(methodName).append(ANSI_RESET).append("\n").append(ANSI_BLUE).append("\u7c7b\u540d\uff1a").append(ANSI_CYAN).append(className).append(ANSI_RESET).append("\n").append(ANSI_BLUE).append("\u8017\u65f6\uff1a").append(ANSI_GREEN).append(endTime - startTime).append(" ms").append(ANSI_RESET).append("\n").append(ANSI_BLUE).append("\u8fd4\u56de\u503c\uff1a\n").append(ANSI_GREEN).append(response).append(ANSI_RESET);
        log.info(exitLog.toString());
        return result;
    }

    private String prettyJson(String json) {
        try {
            JsonElement jsonElement = JsonParser.parseString((String)json);
            return new GsonBuilder().setPrettyPrinting().create().toJson(jsonElement);
        }
        catch (Exception e) {
            return json;
        }
    }
}

