/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.log4j2.listener;

import cn.sunxiansheng.tool.constant.DateParsePatterns;
import java.io.File;
import java.net.InetAddress;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;

public class ApplicationReadyListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationReadyListener.class);

    public void onApplicationEvent(ApplicationReadyEvent event) {
        try {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = context.getConfiguration();
            String logHome = config.getStrSubstitutor().replace("${LOG_HOME}");
            if (logHome == null || logHome.isEmpty()) {
                log.warn("\u672a\u914d\u7f6e LOG_HOME \u5c5e\u6027\uff01");
            } else {
                File logHomeDir = new File(logHome).getCanonicalFile();
                log.info("\u65e5\u5fd7\u5b58\u50a8\u7684\u6839\u76ee\u5f55\u4e3a: {}", (Object)logHomeDir.getAbsolutePath());
            }
            ConfigurableEnvironment environment = event.getApplicationContext().getEnvironment();
            String ip = InetAddress.getLocalHost().getHostAddress();
            String port = environment.getProperty("server.port", "8080");
            String contextPath = environment.getProperty("server.servlet.context-path", "");
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            log.info("\u5e94\u7528\u8bbf\u95ee\u5730\u5740: http://{}:{}{}", new Object[]{ip, port, contextPath});
            log.info("\u524d\u7aef\u53ef\u4ee5\u8bf7\u6c42\u7684\u65e5\u671f\u683c\u5f0f: {}", (Object)Arrays.toString(DateParsePatterns.PARSE_PATTERNS));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u65e5\u5fd7\u5b58\u50a8\u6839\u76ee\u5f55\u3001\u5e94\u7528\u8bbf\u95ee\u5730\u5740\u6216\u65e5\u671f\u683c\u5f0f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }
}

