/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.minio.config;

import cn.sunxiansheng.minio.config.properties.MinioProperties;
import cn.sunxiansheng.minio.utils.MinioUtil;
import io.minio.MinioClient;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MinioProperties.class})
public class MinioAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MinioAutoConfiguration.class);

    @PostConstruct
    public void logConfigSuccess() {
        log.info("MinioAutoConfiguration has been loaded successfully!");
    }

    @Bean
    @ConditionalOnMissingBean
    MinioClient minioClient(MinioProperties minioProperties) {
        return MinioClient.builder().endpoint(minioProperties.getEndpoint()).credentials(minioProperties.getAccessKey(), minioProperties.getSecretKey()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    MinioUtil minioUtil() {
        return new MinioUtil();
    }
}

