/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.minio.utils;

import cn.sunxiansheng.minio.config.properties.MinioProperties;
import io.minio.BucketExistsArgs;
import io.minio.DownloadObjectArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioUtil {
    @Resource
    private MinioClient minioClient;
    @Resource
    private MinioProperties minioProperties;

    public boolean bucketExists(String bucketName) {
        try {
            return this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            throw new RuntimeException("\u68c0\u67e5\u5b58\u50a8\u6876\u662f\u5426\u5b58\u5728\u5931\u8d25", e);
        }
    }

    public List<String> listBucketNames() {
        try {
            return this.minioClient.listBuckets().stream().map(Bucket::name).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("\u5217\u51fa\u6240\u6709\u5b58\u50a8\u6876\u7684\u540d\u5b57\u5931\u8d25", e);
        }
    }

    public void makeBucket(String bucketName) {
        try {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa\u5b58\u50a8\u6876\u5931\u8d25", e);
        }
    }

    public void removeBucket(String bucketName) {
        try {
            this.minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            throw new RuntimeException("\u79fb\u9664\u5b58\u50a8\u6876\u5931\u8d25", e);
        }
    }

    public void downloadObject(String bucketName, String objectName, String fileName) {
        try {
            this.minioClient.downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(bucketName)).object(objectName)).filename(fileName).build());
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0b\u8f7d\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public List<String> putObject(MultipartFile file, String bucketName) {
        try {
            String fileName = file.getOriginalFilename();
            InputStream inputStream = file.getInputStream();
            String dateFolder = new SimpleDateFormat("yyyy/MM/dd").format(new Date());
            String uniqueName = UUID.randomUUID().toString();
            String objectName = dateFolder + "/" + uniqueName + "-" + fileName;
            String contentType = file.getContentType() != null ? file.getContentType() : "application/octet-stream";
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(inputStream, -1L, 0xA00000L).contentType(contentType).build());
            String previewUrl = this.generatePreviewLink(bucketName, objectName);
            String downloadUrl = this.generateDownloadLink(bucketName, objectName);
            return Arrays.asList(previewUrl, downloadUrl);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0a\u4f20\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public String removeObjectOrFolder(String bucketName, String prefix) {
        try {
            Iterable objects = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).prefix(prefix).recursive(true).build());
            for (Result result : objects) {
                String objectName = ((Item)result.get()).objectName();
                this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
            }
            return "All objects under " + prefix + " removed successfully!";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Failed to remove objects under " + prefix;
        }
    }

    public String generateDownloadLink(String bucketName, String objectName) {
        String endpoint = this.minioProperties.getEndpoint();
        return String.format("%s/%s/%s?response-content-disposition=attachment", endpoint, bucketName, objectName);
    }

    public String generatePreviewLink(String bucketName, String objectName) {
        String endpoint = this.minioProperties.getEndpoint();
        return String.format("%s/%s/%s", endpoint, bucketName, objectName);
    }
}

