/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.openai.client;

import cn.sunxiansheng.openai.config.properties.OpenAiProperties;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OpenAiClient {
    @Resource
    private OpenAiProperties openAiProperties;
    private static final OkHttpClient CLIENT = new OkHttpClient.Builder().connectTimeout(120L, TimeUnit.SECONDS).readTimeout(120L, TimeUnit.SECONDS).writeTimeout(120L, TimeUnit.SECONDS).build();
    private static final Logger LOGGER = Logger.getLogger(OpenAiClient.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String askAI(String model, String prompt, boolean base64Encode) {
        try {
            String encodedPrompt = base64Encode ? this.encodeBase64(prompt) : prompt;
            RequestBody body = RequestBody.create((String)this.createJsonRequest(model, encodedPrompt), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
            Request request = new Request.Builder().url(this.openAiProperties.getApiUrl()).header("Authorization", "Bearer " + this.openAiProperties.getApiKey()).header("Content-Type", "application/json").post(body).build();
            try (Response response = CLIENT.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected response: " + response);
                }
                String string = this.parseResponse(response.body().string());
                return string;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error occurred during API request: " + e.getMessage(), e);
            throw new RuntimeException("API request failed", e);
        }
    }

    private String encodeBase64(String prompt) {
        return Base64.getEncoder().encodeToString(prompt.getBytes(StandardCharsets.UTF_8));
    }

    private String createJsonRequest(String model, String encodedPrompt) {
        JsonObject jsonRequest = new JsonObject();
        jsonRequest.addProperty("model", model);
        JsonArray messages = new JsonArray();
        JsonObject systemMessage = new JsonObject();
        systemMessage.addProperty("role", "system");
        systemMessage.addProperty("content", "\u8bf7\u6839\u636e\u4ee5\u4e0b\u5185\u5bb9\u63d0\u4f9b\u95ee\u9898\u7684\u89e3\u51b3\u65b9\u6848\u3002\u4f7f\u7528\u4e2d\u6587\u56de\u7b54\uff0c\u4f7f\u7528markdown\u8bed\u6cd5\u6765\u56de\u7b54\u95ee\u9898\uff0c\u6ce8\u610f\uff0c\u5185\u5bb9\u53ef\u80fd\u7ecf\u8fc7 Base64 \u7f16\u7801\u3002");
        messages.add((JsonElement)systemMessage);
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", encodedPrompt);
        messages.add((JsonElement)userMessage);
        jsonRequest.add("messages", (JsonElement)messages);
        return jsonRequest.toString();
    }

    private String parseResponse(String responseBody) {
        JsonObject jsonObject = JsonParser.parseString((String)responseBody).getAsJsonObject();
        JsonArray choices = jsonObject.getAsJsonArray("choices");
        if (choices != null && choices.size() > 0) {
            JsonObject choice = choices.get(0).getAsJsonObject();
            JsonObject message = choice.getAsJsonObject("message");
            return message.get("content").getAsString();
        }
        throw new RuntimeException("Invalid response: No choices found.");
    }
}

