/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.rabbitmq.config;

import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={RabbitAutoConfiguration.class})
public class RabbitMQConfig {
    @Bean
    public MessageConverter customMessageConverter() {
        return new MessageConverter(){
            private final Jackson2JsonMessageConverter jacksonConverter = new Jackson2JsonMessageConverter();
            private final SimpleMessageConverter simpleMessageConverter = new SimpleMessageConverter();

            public Message toMessage(Object object, MessageProperties messageProperties) throws RuntimeException {
                if (object instanceof String) {
                    messageProperties.setContentType("text/plain");
                    return this.simpleMessageConverter.toMessage(object, messageProperties);
                }
                messageProperties.setContentType("application/json");
                return this.jacksonConverter.toMessage(object, messageProperties);
            }

            public Object fromMessage(Message message) throws RuntimeException {
                String contentType = message.getMessageProperties().getContentType();
                if ("application/json".equals(contentType)) {
                    return this.jacksonConverter.fromMessage(message);
                }
                if ("text/plain".equals(contentType)) {
                    return this.simpleMessageConverter.fromMessage(message);
                }
                throw new RuntimeException("\u81ea\u5b9a\u4e49\u7684\u6d88\u606f\u8f6c\u6362\u5668\u4e0d\u652f\u6301\u8be5\u7c7b\u578b: " + contentType);
            }
        };
    }

    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setMessageConverter(this.customMessageConverter());
        return rabbitTemplate;
    }
}

