/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.redis.config;

import cn.sunxiansheng.redis.config.RedisConfig;
import cn.sunxiansheng.redis.utils.RHash;
import cn.sunxiansheng.redis.utils.RList;
import cn.sunxiansheng.redis.utils.RSet;
import cn.sunxiansheng.redis.utils.RSortedSet;
import cn.sunxiansheng.redis.utils.RString;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@Import(value={RedisConfig.class})
public class RedisAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedisAutoConfiguration.class);
    @Resource
    RedisTemplate<String, Object> redisTemplate;

    @PostConstruct
    public void logConfigSuccess() {
        log.info("RedisAutoConfiguration has been loaded successfully!");
    }

    @Bean
    @ConditionalOnMissingBean
    public RString rString() {
        return new RString(this.redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public RHash rHash() {
        return new RHash(this.redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public RSortedSet rSortedSet() {
        return new RSortedSet(this.redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public RList rList() {
        return new RList(this.redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public RSet rSet() {
        return new RSet(this.redisTemplate);
    }
}

