/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.redis.utils;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class RBase {
    protected RedisTemplate<String, Object> redisTemplate;
    private static final String DEFAULT_KEY_SEPARATOR = ":";

    public RBase(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String buildKeyByDefaultSeparator(String ... parts) {
        return String.join((CharSequence)DEFAULT_KEY_SEPARATOR, parts);
    }

    public String buildKeyByCustomSeparator(String separator, String ... parts) {
        return String.join((CharSequence)separator, parts);
    }

    public Boolean delete(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        return this.redisTemplate.delete((Object)key);
    }

    public Long deleteBatch(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return 0L;
        }
        return this.redisTemplate.delete(keys);
    }

    public Boolean expire(String key, long timeout, TimeUnit unit) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        if (timeout <= 0L) {
            return false;
        }
        return this.redisTemplate.expire((Object)key, timeout, unit);
    }

    public Boolean expire(String key, long timeout) {
        return this.expire(key, timeout, TimeUnit.SECONDS);
    }

    public Long getExpire(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        return this.redisTemplate.getExpire((Object)key);
    }

    public Boolean hasKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        return this.redisTemplate.hasKey((Object)key);
    }

    protected <T> T convertValue(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type == Long.class && value instanceof Integer) {
            return type.cast(((Integer)value).longValue());
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw new ClassCastException("Redis\u4e2d\u7684\u5bf9\u8c61\u8fd0\u884c\u7c7b\u578b\u4e0e\u8bf7\u6c42\u8f6c\u6362\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u4f18\u5148\u68c0\u67e5Redis\u914d\u7f6e\u7c7b\u662f\u5426\u4fdd\u5b58\u4e86\u5bf9\u8c61\u539f\u59cb\u4fe1\u606f\uff01\u671f\u5f85\u7c7b\u578b\uff1a" + type.getName() + "\uff0c\u5b9e\u9645\u7c7b\u578b\uff1a" + value.getClass().getName());
    }

    public <T> T executeLuaScript(String script, Class<T> resultType, Collection<String> keys, Object ... args) {
        if (script == null || script.isEmpty()) {
            throw new IllegalArgumentException("Lua\u811a\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("Redis keys \u4e0d\u80fd\u4e3a\u7a7a");
        }
        DefaultRedisScript redisScript = new DefaultRedisScript(script, resultType);
        return (T)this.redisTemplate.execute((RedisScript)redisScript, (List)keys, args);
    }
}

