/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.redis.utils;

import cn.sunxiansheng.redis.utils.RBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.redis.core.RedisTemplate;

public class RHash
extends RBase {
    public RHash(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
    }

    public void put(String key, String hashKey, Object hashValue) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, hashValue);
    }

    public void putAll(String key, Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Map\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisTemplate.opsForHash().putAll((Object)key, map);
    }

    public Long delete(String key, List<String> hashKeys) {
        if (hashKeys == null || hashKeys.isEmpty()) {
            return 0L;
        }
        return this.redisTemplate.opsForHash().delete((Object)key, hashKeys.toArray());
    }

    public Long delete(String key, String hashKey) {
        if (hashKey == null) {
            return 0L;
        }
        return this.redisTemplate.opsForHash().delete((Object)key, new Object[]{hashKey});
    }

    public <T> T getOneMapValue(String key, String hashKey, Class<T> type) {
        if (hashKey == null) {
            return null;
        }
        Object object = this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
        return this.convertValue(object, type);
    }

    public <T> List<T> getMultiMapValue(String key, Collection<String> hashKeys, Class<T> type) {
        if (hashKeys == null || hashKeys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> keys = new ArrayList<String>(hashKeys);
        List objects = this.redisTemplate.opsForHash().multiGet((Object)key, keys);
        ArrayList<T> result = new ArrayList<T>();
        for (Object obj : objects) {
            result.add(this.convertValue(obj, type));
        }
        return result;
    }

    public <T> Map<String, T> getAll(String key, Class<T> type) {
        Map entries = this.redisTemplate.opsForHash().entries((Object)key);
        if (entries.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, T> result = new HashMap<String, T>();
        for (Map.Entry entry : entries.entrySet()) {
            if (entry.getKey() instanceof String) {
                String strKey = (String)entry.getKey();
                T value = this.convertValue(entry.getValue(), type);
                result.put(strKey, value);
                continue;
            }
            throw new ClassCastException("Redis\u4e2dHash\u7684\u952e\u4e0d\u662fString\u7c7b\u578b\uff1a\u5b9e\u9645\u7c7b\u578b\u4e3a " + entry.getKey().getClass().getName());
        }
        return result;
    }

    public Boolean hasHashKey(String key, String hashKey) {
        if (hashKey == null) {
            return false;
        }
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)hashKey);
    }
}

