/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.redis.utils;

import cn.sunxiansheng.redis.utils.RBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.redis.core.RedisTemplate;

public class RList
extends RBase {
    public RList(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
    }

    public Long leftPush(String key, Object value) {
        return this.redisTemplate.opsForList().leftPush((Object)key, value);
    }

    public <V> Long leftPushAll(String key, List<V> dataList) {
        return this.redisTemplate.opsForList().leftPushAll((Object)key, dataList.toArray());
    }

    public <V> Long leftPushAll(String key, Collection<V> dataCollection) {
        return this.redisTemplate.opsForList().leftPushAll((Object)key, dataCollection.toArray());
    }

    public Long rightPush(String key, Object value) {
        return this.redisTemplate.opsForList().rightPush((Object)key, value);
    }

    public <V> Long rightPushAll(String key, List<V> dataList) {
        return this.redisTemplate.opsForList().rightPushAll((Object)key, dataList.toArray());
    }

    public <V> Long rightPushAll(String key, Collection<V> dataCollection) {
        return this.redisTemplate.opsForList().rightPushAll((Object)key, dataCollection.toArray());
    }

    public Long removeByValue(String key, long count, Object value) {
        return this.redisTemplate.opsForList().remove((Object)key, count, value);
    }

    public <T> T popRight(String key, Class<T> type) {
        Object value = this.redisTemplate.opsForList().rightPop((Object)key);
        return this.convertValue(value, type);
    }

    public <T> T popLeft(String key, Class<T> type) {
        Object value = this.redisTemplate.opsForList().leftPop((Object)key);
        return this.convertValue(value, type);
    }

    public void set(String key, long index, Object value) {
        this.redisTemplate.opsForList().set((Object)key, index, value);
    }

    public <T> List<T> rangeAll(String key, Class<T> type) {
        List range = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        ArrayList<T> result = new ArrayList<T>();
        if (range != null) {
            for (Object item : range) {
                result.add(this.convertValue(item, type));
            }
        }
        return result;
    }

    public <T> T getElementByIndex(String key, long index, Class<T> type) {
        Object value = this.redisTemplate.opsForList().index((Object)key, index);
        return this.convertValue(value, type);
    }

    public Long size(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }
}

