/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.redis.utils;

import cn.sunxiansheng.redis.utils.RBase;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;

public class RSortedSet
extends RBase {
    public RSortedSet(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
    }

    public Boolean add(String key, Object data, double score) {
        return this.redisTemplate.opsForZSet().add((Object)key, data, score);
    }

    public <T> Long addBatch(String key, Set<DataScore<T>> dataScores) {
        HashSet<1> tuples = new HashSet<1>();
        for (final DataScore<T> dataScore : dataScores) {
            tuples.add(new ZSetOperations.TypedTuple<Object>(){

                public Object getValue() {
                    return dataScore.getData();
                }

                public Double getScore() {
                    return dataScore.getScore();
                }

                public int compareTo(ZSetOperations.TypedTuple<Object> o) {
                    return Double.compare(o.getScore(), this.getScore());
                }
            });
        }
        return this.redisTemplate.opsForZSet().add((Object)key, tuples);
    }

    public <T> Long remove(String key, Set<T> dataSet) {
        return this.redisTemplate.opsForZSet().remove((Object)key, dataSet.toArray());
    }

    public Long removeRangeByScore(String key, double min, double max) {
        return this.redisTemplate.opsForZSet().removeRangeByScore((Object)key, min, max);
    }

    public Double changeByDelta(String key, Object data, double delta) {
        return this.redisTemplate.opsForZSet().incrementScore((Object)key, data, delta);
    }

    public <T> Set<ZSetOperations.TypedTuple<T>> reverseRangeWithScores(String key, Class<T> type) {
        Set typedTuples = this.redisTemplate.opsForZSet().reverseRangeWithScores((Object)key, 0L, -1L);
        TreeSet<ZSetOperations.TypedTuple<T>> result = new TreeSet<ZSetOperations.TypedTuple<T>>((a, b) -> Double.compare(b.getScore(), a.getScore()));
        if (typedTuples != null) {
            for (ZSetOperations.TypedTuple tuple : typedTuples) {
                final T value = this.convertValue(tuple.getValue(), type);
                final Double score = tuple.getScore();
                result.add(new ZSetOperations.TypedTuple<T>(){

                    public T getValue() {
                        return value;
                    }

                    public Double getScore() {
                        return score;
                    }

                    public int compareTo(ZSetOperations.TypedTuple<T> o) {
                        return Double.compare(o.getScore(), this.getScore());
                    }
                });
            }
        }
        return result;
    }

    public Double score(String key, Object data) {
        return this.redisTemplate.opsForZSet().score((Object)key, data);
    }

    public Long reverseRank(String key, Object data) {
        return this.redisTemplate.boundZSetOps((Object)key).reverseRank(data);
    }

    public Long zCard(String key) {
        return this.redisTemplate.opsForZSet().zCard((Object)key);
    }

    public Long count(String key, double min, double max) {
        return this.redisTemplate.opsForZSet().count((Object)key, min, max);
    }

    public static class DataScore<T> {
        private T data;
        private Double score;

        public DataScore() {
        }

        public DataScore(T data, Double score) {
            this.data = data;
            this.score = score;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T data) {
            this.data = data;
        }

        public Double getScore() {
            return this.score;
        }

        public void setScore(Double score) {
            this.score = score;
        }
    }
}

