/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.redis.utils;

import cn.sunxiansheng.redis.utils.RBase;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RString
extends RBase {
    public RString(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
    }

    public void set(String key, Object value) {
        this.validateKeyAndValue(key, value);
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public void setWithExpire(String key, Object value, long timeout, TimeUnit unit) {
        this.validateKeyAndValue(key, value);
        this.validateTimeoutAndUnit(timeout, unit);
        this.redisTemplate.opsForValue().set((Object)key, value, timeout, unit);
    }

    public void setWithExpire(String key, Object value, long timeout) {
        this.setWithExpire(key, value, timeout, TimeUnit.SECONDS);
    }

    public Boolean setIfAbsent(String key, Object value, long timeout, TimeUnit unit) {
        this.validateKeyAndValue(key, value);
        this.validateTimeoutAndUnit(timeout, unit);
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, value, timeout, unit);
    }

    public Boolean setIfAbsent(String key, Object value, long timeout) {
        return this.setIfAbsent(key, value, timeout, TimeUnit.SECONDS);
    }

    public <T> T get(String key, Class<T> type) {
        Object value = this.redisTemplate.opsForValue().get((Object)key);
        return this.convertValue(value, type);
    }

    public <T> T getAndSet(String key, T value, Class<T> type) {
        Object oldValue = this.redisTemplate.opsForValue().getAndSet((Object)key, value);
        return this.convertValue(oldValue, type);
    }

    public Long changeByDelta(String key, long delta) {
        if (key == null) {
            throw new IllegalArgumentException("Key \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    private void validateKeyAndValue(String key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Key \u548c Value \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void validateTimeoutAndUnit(long timeout, TimeUnit unit) {
        if (timeout <= 0L || unit == null) {
            throw new IllegalArgumentException("\u8d85\u65f6\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e 0\uff0c\u65f6\u95f4\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

