/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.tool.response;

import cn.sunxiansheng.tool.response.RespBeanEnum;
import java.io.Serializable;

public class ResultWrapper<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean success;
    private int code;
    private String message;
    private T data;

    private ResultWrapper() {
    }

    public static <T> ResultWrapper<T> ok() {
        return new Builder().success(true).code(RespBeanEnum.SUCCESS.getCode()).message(RespBeanEnum.SUCCESS.getMessage()).build();
    }

    public static <T> ResultWrapper<T> ok(T data) {
        return new Builder().success(true).code(RespBeanEnum.SUCCESS.getCode()).message(RespBeanEnum.SUCCESS.getMessage()).data(data).build();
    }

    public static <T> ResultWrapper<T> ok(T data, String message) {
        return new Builder().success(true).code(RespBeanEnum.SUCCESS.getCode()).message(message).data(data).build();
    }

    public static <T> ResultWrapper<T> fail() {
        return new Builder().success(false).code(RespBeanEnum.ERROR.getCode()).message(RespBeanEnum.ERROR.getMessage()).build();
    }

    public static <T> ResultWrapper<T> fail(String message) {
        return new Builder().success(false).code(RespBeanEnum.ERROR.getCode()).message(message).build();
    }

    public static <T> ResultWrapper<T> fail(int code, String message) {
        return new Builder().success(false).code(code).message(message).build();
    }

    public static <T> ResultWrapper<T> fail(int code, String message, T data) {
        return new Builder().success(false).code(code).message(message).data(data).build();
    }

    public static <T> ResultWrapper<T> fail(RespBeanEnum respBeanEnum) {
        return new Builder().success(false).code(respBeanEnum.getCode()).message(respBeanEnum.getMessage()).build();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultWrapper)) {
            return false;
        }
        ResultWrapper other = (ResultWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResultWrapper(success=" + this.isSuccess() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public static class Builder<T> {
        private boolean success;
        private int code;
        private String message;
        private T data;

        public Builder<T> success(boolean success) {
            this.success = success;
            return this;
        }

        public Builder<T> code(int code) {
            this.code = code;
            return this;
        }

        public Builder<T> message(String message) {
            this.message = message;
            return this;
        }

        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ResultWrapper<T> build() {
            ResultWrapper result = new ResultWrapper();
            result.success = this.success;
            result.code = this.code;
            result.message = this.message;
            result.data = this.data;
            return result;
        }
    }
}

