package cn.sunxiansheng.tool.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

/**
 * Description: Json工具类
 *
 * @Author sun
 * @Create 2025/1/24 18:48
 * @Version 1.0
 */
public class JsonUtil {

    private static final Gson loggingGson = new GsonBuilder()
            .setPrettyPrinting() // 启用格式化输出
            .disableHtmlEscaping() // 禁用 HTML 转义
            .create();

    // ANSI 颜色代码 - 绿色
    private static final String ANSI_GREEN = "\u001B[32m";
    private static final String ANSI_RESET = "\u001B[0m";

    /**
     * 格式化打印对象
     *
     * @param object 任意对象
     * @return 格式化后的 JSON 字符串（绿色输出）
     */
    public static String toPrettyJson(Object object) {
        if (object == null) {
            return ANSI_GREEN + "null" + ANSI_RESET;
        }
        try {
            return "\n" + ANSI_GREEN + loggingGson.toJson(object) + ANSI_RESET;
        } catch (Exception e) {
            return ANSI_GREEN + "无法格式化对象为 JSON: " + e.getMessage() + ANSI_RESET;
        }
    }

    /**
     * 格式化打印 JSON 字符串
     *
     * @param jsonString 原始 JSON 字符串
     * @return 格式化后的 JSON 字符串（绿色输出）
     */
    public static String toPrettyJson(String jsonString) {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return ANSI_GREEN + "空的 JSON 字符串" + ANSI_RESET;
        }
        try {
            JsonElement jsonElement = JsonParser.parseString(jsonString);
            return "\n" + ANSI_GREEN + loggingGson.toJson(jsonElement) + ANSI_RESET;
        } catch (Exception e) {
            return ANSI_GREEN + "无法解析并格式化 JSON 字符串: " + e.getMessage() + ANSI_RESET;
        }
    }
}