/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.tool.response;

import cn.sunxiansheng.tool.response.ResultWrapper;
import com.google.gson.Gson;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SunRaysServletResponse {
    private static final Logger log = LoggerFactory.getLogger(SunRaysServletResponse.class);
    private static final Gson gson = new Gson();

    public static <T> void writeResponse(HttpServletResponse response, boolean success, int code, String message, T data) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        ResultWrapper resultWrapper = new ResultWrapper.Builder().success(success).code(code).message(message).data(data).build();
        String jsonResponse = gson.toJson(resultWrapper);
        log.info("SunRaysServletResponse Data: {}", (Object)jsonResponse);
        response.getWriter().write(jsonResponse);
    }

    public static void writeFail(HttpServletResponse response, int code, String message) throws IOException {
        log.error("Fail SunRaysServletResponse: code={}, message={}", (Object)code, (Object)message);
        SunRaysServletResponse.writeResponse(response, false, code, message, null);
    }

    public static <T> void writeSuccess(HttpServletResponse response, int code, String message, T data) throws IOException {
        log.info("Success SunRaysServletResponse: code={}, message={}, data={}", new Object[]{code, message, data});
        SunRaysServletResponse.writeResponse(response, true, code, message, data);
    }
}

