/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.tool.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

public class JsonUtil {
    private static final Gson loggingGson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_RESET = "\u001b[0m";

    public static String toPrettyJson(Object object) {
        if (object == null) {
            return "\u001b[32mnull\u001b[0m";
        }
        try {
            return "\n\u001b[32m" + loggingGson.toJson(object) + ANSI_RESET;
        }
        catch (Exception e) {
            return "\u001b[32m\u65e0\u6cd5\u683c\u5f0f\u5316\u5bf9\u8c61\u4e3a JSON: " + e.getMessage() + ANSI_RESET;
        }
    }

    public static String toPrettyJson(String jsonString) {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return "\u001b[32m\u7a7a\u7684 JSON \u5b57\u7b26\u4e32\u001b[0m";
        }
        try {
            JsonElement jsonElement = JsonParser.parseString((String)jsonString);
            return "\n\u001b[32m" + loggingGson.toJson(jsonElement) + ANSI_RESET;
        }
        catch (Exception e) {
            return "\u001b[32m\u65e0\u6cd5\u89e3\u6790\u5e76\u683c\u5f0f\u5316 JSON \u5b57\u7b26\u4e32: " + e.getMessage() + ANSI_RESET;
        }
    }
}

