/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.tool.utils;

import cn.sunxiansheng.tool.utils.JsonUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtil {
    private static final Logger log = LoggerFactory.getLogger(RequestUtil.class);

    public static String getHeader(HttpServletRequest request, String headerName) {
        if (request == null || headerName == null || headerName.isEmpty()) {
            return null;
        }
        return request.getHeader(headerName);
    }

    public static Map<String, String> getHeaders(HttpServletRequest request, String ... headerNames) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String headerName : headerNames) {
            String headerValue = request.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    public static String getBody(HttpServletRequest request) {
        StringBuilder bodyBuilder = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                bodyBuilder.append(line).append("\n");
            }
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u539f\u59cb\u7684 Body \u6570\u636e\u5931\u8d25\uff01", (Throwable)e);
        }
        String body = bodyBuilder.toString().trim();
        log.info("\u539f\u59cb\u62a5\u6587: {}", (Object)JsonUtil.toPrettyJson(body));
        return body;
    }
}

