/*
 * Decompiled with CFR 0.152.
 */
package cn.sunxiansheng.web.config;

import cn.sunxiansheng.tool.response.ResultWrapper;
import cn.sunxiansheng.web.annotation.IgnoredResultWrapper;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

public class ReturnValueHandlersDecorator
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ReturnValueHandlersDecorator.class);
    @Resource
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;

    public void afterPropertiesSet() {
        List returnValueHandlers = this.requestMappingHandlerAdapter.getReturnValueHandlers();
        assert (returnValueHandlers != null);
        ArrayList<HandlerMethodReturnValueHandler> handlers = new ArrayList<HandlerMethodReturnValueHandler>(returnValueHandlers);
        this.decorateHandlers(handlers);
        this.requestMappingHandlerAdapter.setReturnValueHandlers(handlers);
    }

    private void decorateHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        for (HandlerMethodReturnValueHandler returnValueHandler : returnValueHandlers) {
            if (!(returnValueHandler instanceof RequestResponseBodyMethodProcessor)) continue;
            ControllerReturnValueHandler controllerReturnValueHandler = new ControllerReturnValueHandler(returnValueHandler);
            int index = returnValueHandlers.indexOf(returnValueHandler);
            returnValueHandlers.set(index, controllerReturnValueHandler);
        }
    }

    private static class ControllerReturnValueHandler
    implements HandlerMethodReturnValueHandler {
        private final HandlerMethodReturnValueHandler handler;

        public ControllerReturnValueHandler(HandlerMethodReturnValueHandler handler) {
            this.handler = handler;
        }

        public boolean supportsReturnType(MethodParameter returnType) {
            return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnType.getContainingClass(), ResponseBody.class) || returnType.hasMethodAnnotation(ResponseBody.class);
        }

        public void handleReturnValue(Object o, MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest) throws Exception {
            IgnoredResultWrapper methodAnnotation = (IgnoredResultWrapper)methodParameter.getMethodAnnotation(IgnoredResultWrapper.class);
            if (Objects.nonNull(methodAnnotation)) {
                this.handler.handleReturnValue(o, methodParameter, modelAndViewContainer, nativeWebRequest);
                return;
            }
            if (o instanceof ResultWrapper) {
                this.handler.handleReturnValue(o, methodParameter, modelAndViewContainer, nativeWebRequest);
                return;
            }
            log.info("Controller\u8fd4\u56de\u503c\u5df2\u88ab\u81ea\u52a8\u5305\u88c5\uff0c\u5982\u679c\u4e0a\u4f20\u6587\u4ef6\uff0c\u8bf7\u52a0@IgnoredResultWrapper\u6ce8\u89e3\u53d6\u6d88\u81ea\u52a8\u5305\u88c5\uff01");
            ResultWrapper ok = ResultWrapper.ok((Object)o);
            this.handler.handleReturnValue((Object)ok, methodParameter, modelAndViewContainer, nativeWebRequest);
        }
    }
}

