/*
 * Decompiled with CFR 0.152.
 */
package com.zx.util.controller;

import com.alibaba.fastjson.JSONObject;
import com.zx.util.annotation.ModelMapping;
import com.zx.util.service.BaseRepository;
import com.zx.util.util.MyBaseConverter;
import com.zx.util.util.ReflectUtil;
import com.zx.util.util.SpringManager;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseControllerModel<S, E>
implements ApplicationRunner {
    private static final Logger logger = LoggerFactory.getLogger(BaseControllerModel.class);
    public BaseRepository myRepository;
    private Type[] actualTypeArguments;
    private MyBaseConverter myBaseConverter = new MyBaseConverter();
    private ReflectUtil reflectUtil = new ReflectUtil();

    @RequestMapping(path={""}, method={RequestMethod.POST})
    @ModelMapping
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public synchronized void add(@RequestBody S entityVO) {
        Object entity = this.myBaseConverter.convertSingleObject(entityVO, (Class)this.actualTypeArguments[1]);
        try {
            this.reflectUtil.setValue(entity, "valid", 1);
        }
        catch (Exception e) {
            logger.warn("\u6ca1\u6709\u627e\u5230\u5c5e\u6027\uff1avalid");
        }
        this.myRepository.save(entity);
    }

    @RequestMapping(path={""}, method={RequestMethod.PUT})
    @ModelMapping
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public void update(@RequestBody S entityVO) {
        Object entity = this.myBaseConverter.convertSingleObject(entityVO, (Class)this.actualTypeArguments[1]);
        try {
            this.reflectUtil.setValue(entity, "valid", 1);
        }
        catch (Exception e) {
            logger.warn("\u6ca1\u6709\u627e\u5230\u5c5e\u6027\uff1avalid");
        }
        this.myRepository.save(entity);
    }

    @RequestMapping(path={"/{ids}"}, method={RequestMethod.DELETE})
    @ModelMapping
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public void deleteValid(@PathVariable String ids) {
        this.myRepository.deleteValid(ids);
    }

    @RequestMapping(path={"/{attr}/{condition}"}, method={RequestMethod.GET})
    @ModelMapping
    public Object findByAttr(@PathVariable String attr, @PathVariable String condition) {
        return this.myBaseConverter.convertSingleObject(this.myRepository.findOneByAttr(attr, condition), (Class)this.actualTypeArguments[0]);
    }

    @RequestMapping(path={"/list/{attr}/{condition}"}, method={RequestMethod.GET})
    @ModelMapping
    public List findByAttrs(@PathVariable String attr, @PathVariable String condition, @RequestParam(name="conditionType", required=false) String conditionType) {
        if (!StringUtils.isEmpty((Object)conditionType) && "list".equals(conditionType)) {
            return this.myBaseConverter.convertMultiObjectToList(this.myRepository.findByAttrs(attr, condition), (Class)this.actualTypeArguments[0]);
        }
        return this.myBaseConverter.convertMultiObjectToList(this.myRepository.findByAttr(attr, condition), (Class)this.actualTypeArguments[0]);
    }

    @RequestMapping(path={"/findAll"}, method={RequestMethod.GET})
    @ModelMapping
    public List findAllByConditions(@RequestParam Map<String, Object> tableMap, @RequestParam(name="excludeAttr", required=false) String excludeAttr) {
        if (!StringUtils.isEmpty((Object)excludeAttr) & (tableMap.get("sorter") != null && !"{}".equals(tableMap.get("sorter")))) {
            List<String> excludeAttrs = Arrays.asList(excludeAttr.split(","));
            JSONObject sorter = JSONObject.parseObject((String)tableMap.get("sorter").toString());
            Iterator iterator = sorter.keySet().iterator();
            String sortAttr = (String)iterator.next();
            return this.myBaseConverter.convertMultiObjectToList(this.myRepository.findByConditions(tableMap, excludeAttrs, sortAttr), (Class)this.actualTypeArguments[0]);
        }
        if (!StringUtils.isEmpty((Object)excludeAttr)) {
            List<String> excludeAttrs = Arrays.asList(excludeAttr.split(","));
            return this.myBaseConverter.convertMultiObjectToList(this.myRepository.findByConditions(tableMap, excludeAttrs), (Class)this.actualTypeArguments[0]);
        }
        if (tableMap.get("sorter") != null && !"{}".equals(tableMap.get("sorter"))) {
            JSONObject sorter = JSONObject.parseObject((String)tableMap.get("sorter").toString());
            Iterator iterator = sorter.keySet().iterator();
            String sortAttr = (String)iterator.next();
            return this.myBaseConverter.convertMultiObjectToList(this.myRepository.findByConditions(tableMap, null, sortAttr), (Class)this.actualTypeArguments[0]);
        }
        return this.myBaseConverter.convertMultiObjectToList(this.myRepository.findByConditions(tableMap), (Class)this.actualTypeArguments[0]);
    }

    @RequestMapping(path={"/findByPage"}, method={RequestMethod.GET})
    @ModelMapping
    public Map findByPage(@RequestParam Map<String, Object> tableMap, @RequestParam(name="excludeAttr", required=false) String excludeAttr) {
        if (!StringUtils.isEmpty((Object)excludeAttr) & (tableMap.get("sorter") != null && !"{}".equals(tableMap.get("sorter")))) {
            List<String> excludeAttrs = Arrays.asList(excludeAttr.split(","));
            JSONObject sorter = JSONObject.parseObject((String)tableMap.get("sorter").toString());
            Iterator iterator = sorter.keySet().iterator();
            String sortAttr = (String)iterator.next();
            Page byPage = this.myRepository.findByPage(tableMap, excludeAttrs, sortAttr);
            return this.myBaseConverter.convertMultiObjectToMap(byPage, (Class)this.actualTypeArguments[0]);
        }
        if (!StringUtils.isEmpty((Object)excludeAttr)) {
            List<String> excludeAttrs = Arrays.asList(excludeAttr.split(","));
            Page byPage = this.myRepository.findByPage(tableMap, excludeAttrs);
            return this.myBaseConverter.convertMultiObjectToMap(byPage, (Class)this.actualTypeArguments[0]);
        }
        if (tableMap.get("sorter") != null && !"{}".equals(tableMap.get("sorter"))) {
            JSONObject sorter = JSONObject.parseObject((String)tableMap.get("sorter").toString());
            Iterator iterator = sorter.keySet().iterator();
            String sortAttr = (String)iterator.next();
            Page byPage = this.myRepository.findByPage(tableMap, null, sortAttr);
            return this.myBaseConverter.convertMultiObjectToMap(byPage, (Class)this.actualTypeArguments[0]);
        }
        Page byPage = this.myRepository.findByPage(tableMap);
        return this.myBaseConverter.convertMultiObjectToMap(byPage, (Class)this.actualTypeArguments[0]);
    }

    public void run(ApplicationArguments args) throws Exception {
        Class<?> aClass = this.getClass();
        Type genericSuperclass = aClass.getGenericSuperclass();
        ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        this.actualTypeArguments = actualTypeArguments;
        List<String> strings = Arrays.asList(aClass.getName().split("\\."));
        String controllerName = strings.get(strings.size() - 1);
        String serviceApi = Character.toLowerCase(controllerName.charAt(0)) + controllerName.split("Controller")[0].substring(1);
        this.myRepository = (BaseRepository)SpringManager.getBean(serviceApi + "Repository");
    }
}

