/*
 * Decompiled with CFR 0.152.
 */
package com.zx.util.service.impl;

import com.zx.util.service.BaseRepository;
import com.zx.util.util.ReflectUtil;
import com.zx.util.util.Utils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BaseRepositoryImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements BaseRepository<T, ID> {
    private ReflectUtil reflectUtil = new ReflectUtil();
    private EntityManager entityManager;
    private Utils utils = new Utils();
    private Class<T> clazz;

    @Autowired(required=false)
    public BaseRepositoryImpl(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.clazz = entityInformation.getJavaType();
        this.entityManager = entityManager;
    }

    @Override
    public Page<T> findByPage(Map<String, String> tableMap, List<String> excludeAttr, Map joinField, String sortAttr) {
        int current = Integer.valueOf(tableMap.get("current"));
        int pageSize = Integer.valueOf(tableMap.get("pageSize"));
        PageRequest pageable = !StringUtils.isEmpty((Object)sortAttr) ? PageRequest.of((int)(current - 1), (int)pageSize, (Sort)Utils.sortAttr(tableMap, sortAttr)) : PageRequest.of((int)(current - 1), (int)pageSize);
        Specification specification = this.reflectUtil.createSpecification(tableMap, this.clazz, excludeAttr, joinField);
        return this.findAll(specification, (Pageable)pageable);
    }

    @Override
    public Page<T> findByPage(Map<String, String> tableMap, List<String> excludeAttr, String sortAttr) {
        int current = Integer.valueOf(tableMap.get("current"));
        int pageSize = Integer.valueOf(tableMap.get("pageSize"));
        PageRequest pageable = !StringUtils.isEmpty((Object)sortAttr) ? PageRequest.of((int)(current - 1), (int)pageSize, (Sort)Utils.sortAttr(tableMap, sortAttr)) : PageRequest.of((int)(current - 1), (int)pageSize);
        Specification specification = this.reflectUtil.createSpecification(tableMap, this.clazz, excludeAttr);
        return this.findAll(specification, (Pageable)pageable);
    }

    @Override
    public Page<T> findByPage(Map<String, String> tableMap, List<String> excludeAttr) {
        int current = Integer.valueOf(tableMap.get("current"));
        int pageSize = Integer.valueOf(tableMap.get("pageSize"));
        PageRequest pageable = PageRequest.of((int)(current - 1), (int)pageSize);
        Specification specification = this.reflectUtil.createSpecification(tableMap, this.clazz, excludeAttr);
        return this.findAll(specification, (Pageable)pageable);
    }

    @Override
    public Page<T> findByPage(Map<String, String> tableMap) {
        int current = Integer.valueOf(tableMap.get("current"));
        int pageSize = Integer.valueOf(tableMap.get("pageSize"));
        PageRequest pageable = PageRequest.of((int)(current - 1), (int)pageSize);
        Specification specification = this.reflectUtil.createSpecification(tableMap, this.clazz, null);
        return this.findAll(specification, (Pageable)pageable);
    }

    @Override
    public List<T> findByConditions(Map<String, String> tableMap, List<String> excludeAttr, Map joinField, String sortAttr) {
        Specification specification = this.reflectUtil.createSpecification(tableMap, this.clazz, excludeAttr, joinField);
        if (!StringUtils.isEmpty((Object)sortAttr)) {
            return this.findAll(specification, Utils.sortAttr(tableMap, sortAttr));
        }
        return this.findAll(specification);
    }

    @Override
    public List<T> findByConditions(Map<String, String> tableMap, List<String> excludeAttr, String sortAttr) {
        Specification specification = this.reflectUtil.createSpecification(tableMap, this.clazz, excludeAttr);
        if (!StringUtils.isEmpty((Object)sortAttr)) {
            return this.findAll(specification, Utils.sortAttr(tableMap, sortAttr));
        }
        return this.findAll(specification);
    }

    @Override
    public List<T> findByConditions(Map<String, String> tableMap, List<String> excludeAttr) {
        Specification specification = this.reflectUtil.createSpecification(tableMap, this.clazz, excludeAttr);
        return this.findAll(specification);
    }

    @Override
    public List<T> findByConditions(Map<String, String> tableMap) {
        Specification specification = this.reflectUtil.createSpecification(tableMap, this.clazz, null);
        return this.findAll(specification);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public void deleteValid(String ids) {
        List<Field> idAnnoation;
        List<String> strings = Arrays.asList(ids.split(","));
        if (!CollectionUtils.isEmpty(strings) && !CollectionUtils.isEmpty(idAnnoation = this.reflectUtil.getTargetAnnoation(this.clazz, Id.class))) {
            Field field = idAnnoation.get(0);
            strings.stream().forEach(id -> {
                T object = this.findOneByAttr(field.getName(), (String)id);
                if (object != null) {
                    this.reflectUtil.setValue(object, "valid", 0);
                    this.save(object);
                }
            });
        }
    }

    @Override
    public T findOneByAttr(String attr, String condition) {
        Specification specification = this.reflectUtil.createOneSpecification(attr, condition);
        Optional result = this.findOne(specification);
        if (result.isPresent()) {
            return result.get();
        }
        return null;
    }

    @Override
    public List<T> findByAttr(String attr, String condition) {
        Specification specification = this.reflectUtil.createOneSpecification(attr, condition);
        List all = this.findAll(specification);
        return all;
    }

    @Override
    public List<T> findByAttrs(String attr, String conditions) {
        ArrayList results = new ArrayList();
        if (!StringUtils.isEmpty((Object)conditions)) {
            List<String> cons = Arrays.asList(conditions.split(","));
            cons.stream().forEach(condition -> {
                List<T> byAttr = this.findByAttr(attr, (String)condition);
                if (byAttr != null) {
                    results.addAll(byAttr);
                }
            });
        }
        return results;
    }
}

