/*
 * Decompiled with CFR 0.152.
 */
package com.zx.util.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class FileUtil {
    private static Integer BUFFER_SIZE = 0xA00000;
    public static MessageDigest MD5 = null;

    public static StringBuffer readFile(String strFile) throws IOException {
        StringBuffer strSb = new StringBuffer();
        InputStreamReader inStrR = new InputStreamReader((InputStream)new FileInputStream(strFile), "UTF-8");
        BufferedReader br = new BufferedReader(inStrR);
        String line = br.readLine();
        while (line != null) {
            strSb.append(line).append("\r\n");
            line = br.readLine();
        }
        return strSb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileMD5(File file) {
        FileInputStream fileInputStream = null;
        try {
            int length;
            fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((length = fileInputStream.read(buffer)) != -1) {
                MD5.update(buffer, 0, length);
            }
            String string = new BigInteger(1, MD5.digest()).toString(16);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int countLines(File file) {
        try (LineNumberReader rf = new LineNumberReader(new FileReader(file));){
            long fileLength = file.length();
            rf.skip(fileLength);
            int n = rf.getLineNumber();
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static final List<String> lines(File file) {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static final List<String> lines(File file, String encoding) {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));){
            String line;
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static final List<String> lines(File file, int lines) {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                list.add(line);
                if (list.size() != lines) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static final List<String> lines(File file, int lines, String encoding) {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));){
            String line;
            while ((line = reader.readLine()) != null) {
                list.add(line);
                if (list.size() != lines) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static final boolean appendLine(File file, String str, String encoding) {
        String lineSeparator = System.getProperty("line.separator", "\n");
        try (RandomAccessFile randomFile = new RandomAccessFile(file, "rw");){
            long fileLength = randomFile.length();
            randomFile.seek(fileLength);
            randomFile.write((lineSeparator + str).getBytes(encoding));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean write(File file, String str) {
        try (RandomAccessFile randomFile = new RandomAccessFile(file, "rw");){
            randomFile.writeBytes(str);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean writeAppend(File file, String str) {
        try (RandomAccessFile randomFile = new RandomAccessFile(file, "rw");){
            long fileLength = randomFile.length();
            randomFile.seek(fileLength);
            randomFile.writeBytes(str);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean write(File file, String str, String encoding) {
        try (RandomAccessFile randomFile = new RandomAccessFile(file, "rw");){
            randomFile.write(str.getBytes(encoding));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean writeAppend(File file, String str, String encoding) {
        try (RandomAccessFile randomFile = new RandomAccessFile(file, "rw");){
            long fileLength = randomFile.length();
            randomFile.seek(fileLength);
            randomFile.write(str.getBytes(encoding));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean cleanFile(File file) {
        try (FileWriter fw = new FileWriter(file);){
            fw.write("");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final String mimeType(String file) throws IOException {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        return fileNameMap.getContentTypeFor(file);
    }

    public static final Date modifyTime(File file) {
        return new Date(file.lastModified());
    }

    public static final boolean copy(String resourcePath, String targetPath) {
        File file = new File(resourcePath);
        return FileUtil.copy(file, targetPath);
    }

    public static final boolean copy(File file, String targetFile) {
        try (FileInputStream fin = new FileInputStream(file);
             FileOutputStream fout = new FileOutputStream(new File(targetFile));){
            FileChannel in = fin.getChannel();
            FileChannel out = fout.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(BUFFER_SIZE);
            while (in.read(buffer) != -1) {
                buffer.flip();
                out.write(buffer);
                buffer.clear();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static final boolean createPaths(String paths) {
        File dir = new File(paths);
        return !dir.exists() && dir.mkdir();
    }

    public static final boolean createFiles(String filePath) {
        File file = new File(filePath);
        if (file.isDirectory()) {
            if (!file.exists()) {
                return file.mkdirs();
            }
        } else {
            File dir = file.getParentFile();
            if (!dir.exists() && dir.mkdirs()) {
                try {
                    return file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static final boolean deleteFile(File file) {
        return file.delete();
    }

    public static final boolean deleteDir(File file) {
        List<File> files = FileUtil.listFileAll(file);
        for (File f : files) {
            if (f.isDirectory()) {
                FileUtil.deleteDir(f);
                continue;
            }
            FileUtil.deleteFile(f);
        }
        return file.delete();
    }

    public static final boolean deleteBigFile(File file) {
        return FileUtil.cleanFile(file) && file.delete();
    }

    public static final void copyDir(String filePath, String targetPath) {
        File file = new File(filePath);
        FileUtil.copyDir(file, targetPath);
    }

    public static final void copyDir(File filePath, String targetPath) {
        File[] files;
        File targetFile = new File(targetPath);
        if (!targetFile.exists()) {
            FileUtil.createPaths(targetPath);
        }
        for (File file : files = filePath.listFiles()) {
            String path = file.getName();
            if (file.isDirectory()) {
                FileUtil.copyDir(file, targetPath + "/" + path);
                continue;
            }
            FileUtil.copy(file, targetPath + "/" + path);
        }
    }

    public static final List<File> listFile(String path) {
        File file = new File(path);
        return FileUtil.listFile(file);
    }

    public static final List<File> listFile(String path, boolean child) {
        return FileUtil.listFile(new File(path), child);
    }

    public static final List<File> listFile(File path) {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = path.listFiles()) {
            if (file.isDirectory()) {
                list.addAll(FileUtil.listFile(file));
                continue;
            }
            list.add(file);
        }
        return list;
    }

    public static final List<File> listFile(File path, boolean child) {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = path.listFiles()) {
            if (child && file.isDirectory()) {
                list.addAll(FileUtil.listFile(file));
                continue;
            }
            list.add(file);
        }
        return list;
    }

    public static final List<File> listFileAll(File path) {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = path.listFiles()) {
            list.add(file);
            if (!file.isDirectory()) continue;
            list.addAll(FileUtil.listFileAll(file));
        }
        return list;
    }

    public static final List<File> listFileFilter(File path, FilenameFilter filter) {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = path.listFiles()) {
            if (file.isDirectory()) {
                list.addAll(FileUtil.listFileFilter(file, filter));
                continue;
            }
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            list.add(file);
        }
        return list;
    }

    public static final List<File> listFileFilter(File dirPath, String postfixs) {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dirPath.listFiles()) {
            if (file.isDirectory()) {
                list.addAll(FileUtil.listFileFilter(file, postfixs));
                continue;
            }
            String fileName = file.getName().toLowerCase();
            if (!fileName.endsWith(postfixs.toLowerCase())) continue;
            list.add(file);
        }
        return list;
    }

    public static final List<File> searchFile(File dirPath, String fileName) {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dirPath.listFiles()) {
            if (file.isDirectory()) {
                list.addAll(FileUtil.searchFile(file, fileName));
                continue;
            }
            String Name = file.getName();
            if (!Name.equals(fileName)) continue;
            list.add(file);
        }
        return list;
    }

    public static final String suffix(File file) {
        String fileName = file.getName();
        return fileName.substring(fileName.indexOf(".") + 1);
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ne) {
            ne.printStackTrace();
        }
    }
}

