/*
 * Decompiled with CFR 0.152.
 */
package com.zx.util.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Component;

@Component
public class HttpClientUtil {
    public static String get(JSONObject headers, String url, JSONObject params) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = null;
        ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
        if (params != null) {
            for (String paramName : params.keySet()) {
                paramList.add(new BasicNameValuePair(paramName, params.get((Object)paramName).toString()));
            }
        }
        httpGet = url.contains("?") ? new HttpGet(url + "&" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(paramList, Consts.UTF_8))) : new HttpGet(url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(paramList, Consts.UTF_8)));
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                httpGet.addHeader((String)entry.getKey(), entry.getValue().toString());
            }
        }
        httpGet.addHeader("Content-Type", "application/json");
        HttpEntity entity = httpClient.execute((HttpUriRequest)httpGet).getEntity();
        String response = EntityUtils.toString((HttpEntity)entity);
        httpClient.close();
        return response;
    }

    public static String post(JSONObject headers, String url, JSONObject params) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                httpPost.addHeader((String)entry.getKey(), entry.getValue().toString());
            }
        }
        httpPost.addHeader("Content-Type", "application/json");
        if (params != null) {
            StringEntity stringEntity = new StringEntity(params.toJSONString());
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        HttpEntity entity = httpClient.execute((HttpUriRequest)httpPost).getEntity();
        String response = EntityUtils.toString((HttpEntity)entity);
        httpClient.close();
        return response;
    }

    public static String delete(JSONObject headers, String url, JSONObject params) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpDeleteWithBody httpDelete = new HttpDeleteWithBody(url);
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                httpDelete.addHeader((String)entry.getKey(), entry.getValue().toString());
            }
        }
        httpDelete.addHeader("Content-Type", "application/json");
        if (params != null) {
            StringEntity stringEntity = new StringEntity(params.toJSONString());
            httpDelete.setEntity((HttpEntity)stringEntity);
        }
        HttpEntity entity = httpClient.execute((HttpUriRequest)httpDelete).getEntity();
        String response = EntityUtils.toString((HttpEntity)entity);
        httpClient.close();
        return response;
    }

    public static String put(JSONObject headers, String url, JSONObject params) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPut httpPut = new HttpPut(url);
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                httpPut.addHeader((String)entry.getKey(), entry.getValue().toString());
            }
        }
        httpPut.addHeader("Content-Type", "application/json");
        if (params != null) {
            StringEntity stringEntity = new StringEntity(params.toJSONString());
            httpPut.setEntity((HttpEntity)stringEntity);
        }
        HttpEntity entity = httpClient.execute((HttpUriRequest)httpPut).getEntity();
        String response = EntityUtils.toString((HttpEntity)entity);
        httpClient.close();
        return response;
    }

    public static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "DELETE";

        public String getMethod() {
            return METHOD_NAME;
        }

        public HttpDeleteWithBody(String uri) {
            this.setURI(URI.create(uri));
        }

        public HttpDeleteWithBody(URI uri) {
            this.setURI(uri);
        }

        public HttpDeleteWithBody() {
        }
    }
}

