/*
 * Decompiled with CFR 0.152.
 */
package com.zx.util.util;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class ImageUtil {
    public static BufferedImage grayImage(BufferedImage bufferedImage) throws Exception {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        BufferedImage grayBufferedImage = new BufferedImage(width, height, bufferedImage.getType());
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int color = bufferedImage.getRGB(i, j);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int gray = (int)(0.3 * (double)r + 0.59 * (double)g + 0.11 * (double)b);
                int newPixel = ImageUtil.colorToRGB(255, gray, gray, gray);
                grayBufferedImage.setRGB(i, j, newPixel);
            }
        }
        return grayBufferedImage;
    }

    private static int colorToRGB(int alpha, int red, int green, int blue) {
        int newPixel = 0;
        newPixel += alpha;
        newPixel <<= 8;
        newPixel += red;
        newPixel <<= 8;
        newPixel += green;
        newPixel <<= 8;
        return newPixel += blue;
    }

    public static BufferedImage binaryImage(BufferedImage image) throws Exception {
        int w = image.getWidth();
        int h = image.getHeight();
        float[] rgb = new float[3];
        double[][] zuobiao = new double[w][h];
        int black = new Color(0, 0, 0).getRGB();
        int white = new Color(255, 255, 255).getRGB();
        BufferedImage bi = new BufferedImage(w, h, 12);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int pixel = image.getRGB(x, y);
                rgb[0] = (pixel & 0xFF0000) >> 16;
                rgb[1] = (pixel & 0xFF00) >> 8;
                rgb[2] = pixel & 0xFF;
                float avg = (rgb[0] + rgb[1] + rgb[2]) / 3.0f;
                zuobiao[x][y] = avg;
            }
        }
        double SW = 192.0;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                if (zuobiao[x][y] < SW) {
                    bi.setRGB(x, y, black);
                    continue;
                }
                bi.setRGB(x, y, white);
            }
        }
        return bi;
    }

    public static double getGray(double[][] zuobiao, int x, int y, int w, int h) {
        double rs = zuobiao[x][y] + (x == 0 ? 255.0 : zuobiao[x - 1][y]) + (x == 0 || y == 0 ? 255.0 : zuobiao[x - 1][y - 1]) + (x == 0 || y == h - 1 ? 255.0 : zuobiao[x - 1][y + 1]) + (y == 0 ? 255.0 : zuobiao[x][y - 1]) + (y == h - 1 ? 255.0 : zuobiao[x][y + 1]) + (x == w - 1 ? 255.0 : zuobiao[x + 1][y]) + (x == w - 1 || y == 0 ? 255.0 : zuobiao[x + 1][y - 1]) + (x == w - 1 || y == h - 1 ? 255.0 : zuobiao[x + 1][y + 1]);
        return rs / 9.0;
    }

    public static BufferedImage denoise(BufferedImage image) {
        int x;
        int y;
        int size;
        int y2;
        int x2;
        int w = image.getWidth();
        int h = image.getHeight();
        int white = new Color(255, 255, 255).getRGB();
        if (ImageUtil.isWhite(image.getRGB(1, 0)) && ImageUtil.isWhite(image.getRGB(0, 1)) && ImageUtil.isWhite(image.getRGB(1, 1))) {
            image.setRGB(0, 0, white);
        }
        if (ImageUtil.isWhite(image.getRGB(w - 2, 0)) && ImageUtil.isWhite(image.getRGB(w - 1, 1)) && ImageUtil.isWhite(image.getRGB(w - 2, 1))) {
            image.setRGB(w - 1, 0, white);
        }
        if (ImageUtil.isWhite(image.getRGB(0, h - 2)) && ImageUtil.isWhite(image.getRGB(1, h - 1)) && ImageUtil.isWhite(image.getRGB(1, h - 2))) {
            image.setRGB(0, h - 1, white);
        }
        if (ImageUtil.isWhite(image.getRGB(w - 2, h - 1)) && ImageUtil.isWhite(image.getRGB(w - 1, h - 2)) && ImageUtil.isWhite(image.getRGB(w - 2, h - 2))) {
            image.setRGB(w - 1, h - 1, white);
        }
        for (x2 = 1; x2 < w - 1; ++x2) {
            y2 = 0;
            if (!ImageUtil.isBlack(image.getRGB(x2, y2))) continue;
            size = 0;
            if (ImageUtil.isWhite(image.getRGB(x2 - 1, y2))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x2 + 1, y2))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x2, y2 + 1))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x2 - 1, y2 + 1))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x2 + 1, y2 + 1))) {
                ++size;
            }
            if (size < 5) continue;
            image.setRGB(x2, y2, white);
        }
        for (x2 = 1; x2 < w - 1; ++x2) {
            y2 = h - 1;
            if (!ImageUtil.isBlack(image.getRGB(x2, y2))) continue;
            size = 0;
            if (ImageUtil.isWhite(image.getRGB(x2 - 1, y2))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x2 + 1, y2))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x2, y2 - 1))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x2 + 1, y2 - 1))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x2 - 1, y2 - 1))) {
                ++size;
            }
            if (size < 5) continue;
            image.setRGB(x2, y2, white);
        }
        for (y = 1; y < h - 1; ++y) {
            x = 0;
            if (!ImageUtil.isBlack(image.getRGB(x, y))) continue;
            size = 0;
            if (ImageUtil.isWhite(image.getRGB(x + 1, y))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x, y + 1))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x, y - 1))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x + 1, y - 1))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x + 1, y + 1))) {
                ++size;
            }
            if (size < 5) continue;
            image.setRGB(x, y, white);
        }
        for (y = 1; y < h - 1; ++y) {
            x = w - 1;
            if (!ImageUtil.isBlack(image.getRGB(x, y))) continue;
            size = 0;
            if (ImageUtil.isWhite(image.getRGB(x - 1, y))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x, y + 1))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x, y - 1))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x - 1, y + 1))) {
                ++size;
            }
            if (ImageUtil.isWhite(image.getRGB(x - 1, y - 1))) {
                ++size;
            }
            if (size < 5) continue;
            image.setRGB(x, y, white);
        }
        for (y = 1; y < h - 1; ++y) {
            for (x = 1; x < w - 1; ++x) {
                if (!ImageUtil.isBlack(image.getRGB(x, y))) continue;
                size = 0;
                if (ImageUtil.isWhite(image.getRGB(x - 1, y))) {
                    ++size;
                }
                if (ImageUtil.isWhite(image.getRGB(x + 1, y))) {
                    ++size;
                }
                if (ImageUtil.isWhite(image.getRGB(x, y + 1))) {
                    ++size;
                }
                if (ImageUtil.isWhite(image.getRGB(x, y - 1))) {
                    ++size;
                }
                if (ImageUtil.isWhite(image.getRGB(x - 1, y + 1))) {
                    ++size;
                }
                if (ImageUtil.isWhite(image.getRGB(x + 1, y - 1))) {
                    ++size;
                }
                if (ImageUtil.isWhite(image.getRGB(x + 1, y + 1))) {
                    ++size;
                }
                if (ImageUtil.isWhite(image.getRGB(x - 1, y - 1))) {
                    ++size;
                }
                if (size < 8) continue;
                image.setRGB(x, y, white);
            }
        }
        return image;
    }

    public static boolean isBlack(int colorInt) {
        Color color = new Color(colorInt);
        return color.getRed() + color.getGreen() + color.getBlue() <= 300;
    }

    public static boolean isWhite(int colorInt) {
        Color color = new Color(colorInt);
        return color.getRed() + color.getGreen() + color.getBlue() > 300;
    }

    public static int isBlack(int colorInt, int whiteThreshold) {
        Color color = new Color(colorInt);
        if (color.getRed() + color.getGreen() + color.getBlue() <= whiteThreshold) {
            return 1;
        }
        return 0;
    }
}

