/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.service.impl;

import com.zx.utils.service.BaseRepository;
import com.zx.utils.util.SpecificationUtil;
import com.zx.utils.util.Utils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BaseRepositoryImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements BaseRepository<T, ID> {
    private final SpecificationUtil specificationUtil = new SpecificationUtil();
    private EntityManager entityManager;
    private final Class<T> clazz;

    @Autowired(required=false)
    public BaseRepositoryImpl(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.clazz = entityInformation.getJavaType();
        this.entityManager = entityManager;
    }

    @Override
    public Page<T> findByPage(Map<String, String> objConditions, Integer current, Integer pageSize, List<String> excludeLikeAttr, String sortAttr) {
        PageRequest pageable = !StringUtils.isEmpty((Object)sortAttr) ? PageRequest.of((int)(current - 1), (int)pageSize, (Sort)Utils.sortAttr(objConditions, sortAttr)) : PageRequest.of((int)(current - 1), (int)pageSize);
        Specification<T> specification = this.specificationUtil.createSpecification(objConditions, this.clazz, excludeLikeAttr);
        return this.findAll(specification, (Pageable)pageable);
    }

    @Override
    public List<T> findByConditions(Map<String, String> objConditions, List<String> excludeLikeAttr, String sortAttr) {
        Specification<T> specification = this.specificationUtil.createSpecification(objConditions, this.clazz, excludeLikeAttr);
        if (!StringUtils.isEmpty((Object)sortAttr)) {
            return this.findAll(specification, Utils.sortAttr(objConditions, sortAttr));
        }
        return this.findAll(specification);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public void deleteValid(String ids) {
        List<Field> idAnnoation;
        List<String> strings = Arrays.asList(ids.split(","));
        if (!CollectionUtils.isEmpty(strings) && !CollectionUtils.isEmpty(idAnnoation = this.specificationUtil.getTargetAnnoation(this.clazz, Id.class))) {
            Field field = idAnnoation.get(0);
            strings.forEach(id -> {
                T object = this.findOneByAttr(field.getName(), (String)id);
                if (object != null) {
                    this.specificationUtil.setValue(object, "valid", 0);
                    this.save(object);
                }
            });
        }
    }

    @Override
    public T findOneByAttr(String attr, String condition) {
        Specification specification = this.specificationUtil.createOneSpecification(attr, condition);
        Optional result = this.findOne(specification);
        return result.orElse(null);
    }

    @Override
    public List<T> findByAttr(String attr, String condition) {
        Specification specification = this.specificationUtil.createOneSpecification(attr, condition);
        return this.findAll(specification);
    }
}

