/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ListUtil {
    public static String joinList(List data, String split) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            Object item = data.get(i);
            if (item == null) continue;
            result.append(item.toString());
            if (i + 1 >= data.size()) continue;
            result.append(split);
        }
        return result.toString();
    }

    public static List<String> splitIntoList(String data, String split) {
        if (data == null) {
            return null;
        }
        String[] splitArray = data.split(split);
        if (splitArray.length > 0) {
            ArrayList<String> resultList = new ArrayList<String>();
            for (String item : splitArray) {
                if (item == null || "".equals(item)) continue;
                resultList.add(item);
            }
            return resultList;
        }
        return null;
    }

    public static <E> Map<String, Object> toPage(List<E> data, int current, int pageSize) {
        if (data == null || data.size() <= 0) {
            return null;
        }
        HashMap<String, Object> destMap = new HashMap<String, Object>(4);
        List pageList = data.stream().skip((current - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        destMap.put("list", pageList);
        destMap.put("current", current);
        destMap.put("pageSize", pageSize);
        destMap.put("total", data.size());
        return destMap;
    }

    public static <E> List<E> getListDiff(List<E> list1, List<E> list2) {
        if (list1 == null || list1.isEmpty()) {
            return list2 == null || list2.isEmpty() ? new ArrayList() : list2;
        }
        if (list2 == null || list2.isEmpty()) {
            return list1 == null || list1.isEmpty() ? new ArrayList() : list1;
        }
        HashSet<E> diffSet = new HashSet<E>(list1);
        HashSet<E> setOfCommonElements = new HashSet<E>(list2);
        diffSet.addAll(list2);
        setOfCommonElements.retainAll(list1);
        diffSet.removeAll(setOfCommonElements);
        return new ArrayList<E>(diffSet);
    }

    public static <E> Boolean isEmpty(List<E> list) {
        return list == null || list.size() == 0;
    }
}

