/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.util;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class Utils {
    static Pattern numberPattern = Pattern.compile("[0-9]*");

    public static void main(String[] args) throws IOException {
    }

    public static Date getNowDate() {
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd H:mm:ss");
        String dateStr = dateFormat.format(now);
        try {
            Date parse = dateFormat.parse(dateStr);
            return parse;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromInputStream(InputStream inputStream) throws IOException {
        String s = "";
        StringBuffer sb = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((s = bufferedReader.readLine()) != null) {
                sb.append(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            bufferedReader.close();
            inputStream.close();
        }
        return sb.toString();
    }

    public static String getIp() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            System.err.println("IP\u5730\u5740\u83b7\u53d6\u5931\u8d25" + e.toString());
        }
        return "";
    }

    public static Date timeToDate(String time) {
        SimpleDateFormat sdfTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str = sdfTime.format(Long.valueOf(time));
        try {
            Date date = sdfTime.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String stringToTime(String date) {
        SimpleDateFormat sdfTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date dateDate = sdfTime.parse(date);
            return String.valueOf(dateDate.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Sort sortAttr(Map<String, String> tableMap, String sorterBy) {
        Iterator iterator;
        String sortAttr;
        JSONObject sorter;
        Sort sort = tableMap.get("sorter") != null && !"{}".equals(tableMap.get("sorter")) ? ("ascend".equals((sorter = JSONObject.parseObject((String)tableMap.get("sorter"))).get((Object)(sortAttr = (String)(iterator = sorter.keySet().iterator()).next()))) ? new Sort(Sort.Direction.ASC, new String[]{sortAttr}) : new Sort(Sort.Direction.DESC, new String[]{sortAttr})) : new Sort(Sort.Direction.ASC, new String[]{sorterBy});
        return sort;
    }

    public static boolean isNumeric(String str) {
        Matcher isNum = numberPattern.matcher(str);
        return !StringUtils.isEmpty((Object)str) && isNum.matches();
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        System.out.println("x-forwarded-for ip: " + ip);
        if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip) && ip.indexOf(",") != -1) {
            ip = ip.split(",")[0];
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
            System.out.println("Proxy-Client-IP ip: " + ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
            System.out.println("WL-Proxy-Client-IP ip: " + ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
            System.out.println("HTTP_CLIENT_IP ip: " + ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            System.out.println("HTTP_X_FORWARDED_FOR ip: " + ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
            System.out.println("X-Real-IP ip: " + ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
            System.out.println("getRemoteAddr ip: " + ip);
        }
        System.out.println("\u83b7\u53d6\u5ba2\u6237\u7aefip: " + ip);
        return ip;
    }

    public static Object covertStr(String str, Class<?> tClass) {
        if (tClass == Long.class) {
            return Long.valueOf(str);
        }
        if (tClass == Integer.class || tClass == Integer.TYPE || tClass == Short.TYPE) {
            return Integer.valueOf(str);
        }
        return str;
    }
}

