/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.controller;

import com.zx.utils.annotation.ModelMapping;
import com.zx.utils.repository.BaseRepository;
import com.zx.utils.util.BaseConverter;
import com.zx.utils.util.ReflectUtil;
import com.zx.utils.util.SpringManager;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseControllerModel<S, E>
implements ApplicationRunner {
    private static final Logger logger = LoggerFactory.getLogger(BaseControllerModel.class);
    public BaseRepository<E, Long> baseRepository;
    private Type[] actualTypeArguments;
    private final BaseConverter baseConverter = new BaseConverter();
    private final ReflectUtil reflectUtil = new ReflectUtil();

    @RequestMapping(path={""}, method={RequestMethod.POST})
    @ModelMapping
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public synchronized void add(@RequestBody S entityVO) {
        Object entity = this.baseConverter.convertSingleObject(entityVO, (Class)this.actualTypeArguments[1]);
        try {
            ReflectUtil.setValue(entity, "valid", 1);
        }
        catch (Exception e) {
            logger.warn("\u6ca1\u6709\u627e\u5230\u5c5e\u6027\uff1avalid");
        }
        this.baseRepository.save(entity);
    }

    @RequestMapping(path={""}, method={RequestMethod.PUT})
    @ModelMapping
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public void update(@RequestBody S entityVO) {
        Object entity = this.baseConverter.convertSingleObject(entityVO, (Class)this.actualTypeArguments[1]);
        try {
            ReflectUtil.setValue(entity, "valid", 1);
        }
        catch (Exception e) {
            logger.warn("\u6ca1\u6709\u627e\u5230\u5c5e\u6027\uff1avalid");
        }
        this.baseRepository.save(entity);
    }

    @RequestMapping(path={"/{ids}"}, method={RequestMethod.DELETE})
    @ModelMapping
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public void deleteValid(@PathVariable String ids) {
        this.baseRepository.deleteValid(ids);
    }

    @RequestMapping(path={"/{attr}/{condition}"}, method={RequestMethod.GET})
    @ModelMapping
    public S findByAttr(@PathVariable String attr, @PathVariable String condition) {
        return (S)this.baseConverter.convertSingleObject(this.baseRepository.findOneByAttr(attr, condition), (Class)this.actualTypeArguments[0]);
    }

    @RequestMapping(path={"/list/{attr}/{condition}"}, method={RequestMethod.GET})
    @ModelMapping
    public List<S> findByAttrs(@PathVariable String attr, @PathVariable String condition) {
        return this.baseConverter.convertMultiObjectToList(this.baseRepository.findByAttr(attr, condition), (Class)this.actualTypeArguments[0]);
    }

    @RequestMapping(path={"/findAll"}, method={RequestMethod.GET})
    @ModelMapping
    public List<S> findAllByConditions(@RequestParam Map<String, String> objConditions, @RequestParam(name="sorter", required=false) String sorter, @RequestParam(name="excludeLikeAttr", defaultValue="", required=false) String excludeLikeAttr) {
        List<String> excludeAttrs = Arrays.asList(excludeLikeAttr.split(","));
        List<E> byConditions = this.baseRepository.findByConditions(objConditions, excludeAttrs, sorter);
        return this.baseConverter.convertMultiObjectToList(byConditions, (Class)this.actualTypeArguments[0]);
    }

    @RequestMapping(path={"/findByPage"}, method={RequestMethod.GET})
    @ModelMapping
    public Map<String, Object> findByPage(@RequestParam Map<String, String> objConditions, @RequestParam(name="sorter", required=false) String sorter, @RequestParam(name="excludeLikeAttr", defaultValue="", required=false) String excludeLikeAttr, @RequestParam(name="current") Integer current, @RequestParam(name="pageSize") Integer pageSize) {
        List<String> excludeAttrs = Arrays.asList(excludeLikeAttr.split(","));
        Page<E> byPage = this.baseRepository.findByPage(objConditions, current, pageSize, excludeAttrs, sorter);
        return this.baseConverter.convertMultiObjectToMap(byPage, (Class)this.actualTypeArguments[0]);
    }

    public void run(ApplicationArguments args) {
        Class<?> aClass = this.getClass();
        Type genericSuperclass = aClass.getGenericSuperclass();
        ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        this.actualTypeArguments = actualTypeArguments;
        List<String> strings = Arrays.asList(aClass.getName().split("\\."));
        String controllerName = strings.get(strings.size() - 1);
        String serviceApi = Character.toLowerCase(controllerName.charAt(0)) + controllerName.split("Controller")[0].substring(1);
        this.baseRepository = (BaseRepository)SpringManager.getBean(serviceApi + "Repository");
    }
}

