/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.util;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.cglib.beans.BeanGenerator;

public class DynamicObject {
    Object dynamicBean;
    private static ObjectMapper objectMapper = new ObjectMapper();
    Class clazz;

    public DynamicObject(Map dynAttrMap) {
        this.dynamicBean = this.generateBean(dynAttrMap);
        this.clazz = this.dynamicBean.getClass();
    }

    public DynamicObject(Object object) throws IllegalAccessException, NoSuchFieldException {
        this.dynamicBean = this.generateBean(this.getFields(object));
        Map<String, Object> values = this.getValues(object);
        for (String key : values.keySet()) {
            Object value = values.get(key);
            this.put(key, value);
        }
        this.clazz = this.dynamicBean.getClass();
    }

    public static DynamicObject parseMap(Map<String, Object> targetMap) throws NoSuchFieldException, IllegalAccessException {
        DynamicObject dynmicVO = new DynamicObject();
        for (Map.Entry<String, Object> entry : targetMap.entrySet()) {
            dynmicVO.put(entry.getKey(), entry.getValue());
        }
        return dynmicVO;
    }

    public static DynamicObject parseString(String jsonString) throws NoSuchFieldException, IllegalAccessException {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        return DynamicObject.parseMap((Map<String, Object>)jsonObject);
    }

    public Map<String, Object> getValues() throws IllegalAccessException {
        HashMap<String, Object> fieldValuesMap = new HashMap<String, Object>(16);
        if (this.clazz != null) {
            Field[] fields;
            for (Field field : fields = this.clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Object fieldValue = field.get(this.dynamicBean);
                fieldValuesMap.put(field.getName().split("\\$cglib_prop_")[1], fieldValue);
            }
            return fieldValuesMap;
        }
        return fieldValuesMap;
    }

    public Map<String, Object> getValues(Object object) throws IllegalAccessException {
        HashMap<String, Object> fieldValuesMap = new HashMap<String, Object>(16);
        Class<?> clazz = object.getClass();
        if (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Object fieldValue = field.get(object);
                fieldValuesMap.put(field.getName(), fieldValue);
            }
            return fieldValuesMap;
        }
        return fieldValuesMap;
    }

    public void put(String property, Object value) throws IllegalAccessException, NoSuchFieldException {
        Field declaredField;
        try {
            declaredField = this.clazz.getDeclaredField("$cglib_prop_" + property);
        }
        catch (Exception e) {
            Map<String, Class<?>> fields = this.getFields();
            fields.put(property, Object.class);
            Map<String, Object> values = this.getValues();
            this.dynamicBean = this.generateBean(fields);
            this.clazz = this.dynamicBean.getClass();
            values.put(property, value);
            for (String putKey : values.keySet()) {
                Object putValue = values.get(putKey);
                Field field = this.clazz.getDeclaredField("$cglib_prop_" + putKey);
                field.setAccessible(true);
                field.set(this.dynamicBean, putValue);
            }
            return;
        }
        declaredField.setAccessible(true);
        declaredField.set(this.dynamicBean, value);
    }

    public void putAll(Object object) throws IllegalAccessException, NoSuchFieldException {
        Class<?> clazz = object.getClass();
        Field[] declaredFields = clazz.getDeclaredFields();
        HashMap<String, Object> fieldValuesMap = new HashMap<String, Object>(16);
        HashMap fieldTypeMap = new HashMap(16);
        for (Field field : declaredFields) {
            field.setAccessible(true);
            Object fieldValue = field.get(object);
            fieldValuesMap.put(field.getName(), fieldValue);
            fieldTypeMap.put(field.getName(), field.getType());
        }
        fieldTypeMap.putAll(this.getFields());
        fieldValuesMap.putAll(this.getValues());
        this.dynamicBean = this.generateBean(fieldTypeMap);
        this.clazz = this.dynamicBean.getClass();
        for (String key : fieldValuesMap.keySet()) {
            Object value = fieldValuesMap.get(key);
            this.put(key, value);
        }
    }

    public Map<String, Class<?>> getFields() throws IllegalAccessException {
        HashMap attrMap = new HashMap(16);
        if (this.clazz != null) {
            Iterator<String> iterator = this.getValues().keySet().iterator();
            while (iterator.hasNext()) {
                attrMap.put(iterator.next(), Object.class);
            }
        }
        return attrMap;
    }

    public Map<String, Class<?>> getFields(Object object) throws IllegalAccessException {
        Class<?> clazz = object.getClass();
        HashMap attrMap = new HashMap(16);
        if (clazz != null) {
            Iterator<String> iterator = this.getValues(object).keySet().iterator();
            while (iterator.hasNext()) {
                attrMap.put(iterator.next(), Object.class);
            }
        }
        return attrMap;
    }

    public JsonNode get(String property) {
        JsonNode jsonNode = objectMapper.valueToTree(this.dynamicBean);
        return jsonNode.get(property);
    }

    public <E> E getToObject(String property) throws NoSuchFieldException, IllegalAccessException {
        Field declaredField = this.clazz.getDeclaredField("$cglib_prop_" + property);
        declaredField.setAccessible(true);
        Class<?> type = declaredField.getType();
        return (E)declaredField.get(this.dynamicBean);
    }

    public Object getEntity() {
        return this.dynamicBean;
    }

    private Object generateBean(Map dynAttrMap) {
        BeanGenerator generator = new BeanGenerator();
        if (dynAttrMap != null) {
            Iterator iterator = dynAttrMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                generator.addProperty(key, (Class)dynAttrMap.get(key));
            }
        }
        return generator.create();
    }

    public Object getDynamicBean() {
        return this.dynamicBean;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public void setDynamicBean(Object dynamicBean) {
        this.dynamicBean = dynamicBean;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicObject)) {
            return false;
        }
        DynamicObject other = (DynamicObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$dynamicBean = this.getDynamicBean();
        Object other$dynamicBean = other.getDynamicBean();
        if (this$dynamicBean == null ? other$dynamicBean != null : !this$dynamicBean.equals(other$dynamicBean)) {
            return false;
        }
        Class this$clazz = this.getClazz();
        Class other$clazz = other.getClazz();
        return !(this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $dynamicBean = this.getDynamicBean();
        result = result * 59 + ($dynamicBean == null ? 43 : $dynamicBean.hashCode());
        Class $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        return result;
    }

    public String toString() {
        return "DynamicObject(dynamicBean=" + this.getDynamicBean() + ", clazz=" + this.getClazz() + ")";
    }

    public DynamicObject() {
    }
}

