/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class MapUtil {
    public static <T> Map<String, T> filter(Map<String, T> map, Predicate<Map.Entry<String, T>> predicate) {
        HashMap<String, T> newMap = new HashMap<String, T>(8);
        for (Map.Entry<String, T> entry : map.entrySet()) {
            String key = entry.getKey();
            T value = entry.getValue();
            if (!predicate.test(entry)) continue;
            newMap.put(key, value);
        }
        return newMap;
    }

    public static <T> List<Map.Entry<String, T>> sort(Map<String, T> map, Comparetor<Map.Entry<String, T>> comparator) {
        ArrayList<Map.Entry<String, T>> resultList = new ArrayList<Map.Entry<String, T>>();
        resultList.addAll(map.entrySet());
        MapUtil.quickSort(resultList, 0, map.size() - 1, comparator);
        return resultList;
    }

    public static <L> void quickSort(List<L> a, int start, int end, Comparetor<L> comparator) {
        if (a.size() < 0) {
            return;
        }
        if (start >= end) {
            return;
        }
        int left = start;
        int right = end;
        L temp = a.get(left);
        while (left < right) {
            while (left < right && comparator.compare(a.get(right), temp).booleanValue()) {
                --right;
            }
            a.set(left, a.get(right));
            while (left < right && !comparator.compare(a.get(left), temp).booleanValue()) {
                ++left;
            }
            a.set(right, a.get(left));
        }
        a.set(left, temp);
        MapUtil.quickSort(a, start, left - 1, comparator);
        MapUtil.quickSort(a, left + 1, end, comparator);
    }

    public static <T> Boolean ascByValue(Map.Entry<String, T> entry1, Map.Entry<String, T> entry2) {
        return entry1.getValue().toString().compareTo(entry2.getValue().toString()) >= 0;
    }

    public static <T> Boolean descByValue(Map.Entry<String, T> entry1, Map.Entry<String, T> entry2) {
        return entry1.getValue().toString().compareTo(entry2.getValue().toString()) <= 0;
    }

    public static <T> Boolean ascByKey(Map.Entry<String, T> entry1, Map.Entry<String, T> entry2) {
        return entry1.getKey().compareTo(entry2.getKey()) >= 0;
    }

    public static <T> Boolean descByKey(Map.Entry<String, T> entry1, Map.Entry<String, T> entry2) {
        return entry1.getKey().compareTo(entry2.getKey()) <= 0;
    }

    public static <K, V> Boolean isEmpty(Map<K, V> map) {
        return map == null || map.size() == 0;
    }

    @FunctionalInterface
    public static interface Comparetor<T> {
        public Boolean compare(T var1, T var2);
    }
}

