/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.quartz.impl;

import com.alibaba.fastjson.JSONObject;
import com.zx.utils.constant.Constants;
import com.zx.utils.entity.BaseScheduledTaskEntity;
import com.zx.utils.quartz.BaseQuartzManager;
import com.zx.utils.repository.BaseSchedulerTaskRepository;
import com.zx.utils.util.ListUtil;
import com.zx.utils.util.TimeUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BaseQuartzManagerImpl
implements BaseQuartzManager,
ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(BaseQuartzManagerImpl.class);
    @Autowired
    BaseSchedulerTaskRepository baseSchedulerTaskRepository;
    Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public void createJob(Class<? extends Job> jobClass, String jobName, String jobGroupName, String cronExpression, JSONObject params, boolean exeOnce) {
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionFireAndProceed();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobName, jobGroupName).startNow().withSchedule((ScheduleBuilder)scheduleBuilder).build();
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).build();
        trigger.getJobDataMap().putAll((Map)params);
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
            this.scheduler.start();
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff0cjobName\uff1a{}\uff0cjobGroupName\uff1a{}", (Object)jobName, (Object)jobGroupName);
        }
        List<BaseScheduledTaskEntity> scheduledJobEntities = this.baseSchedulerTaskRepository.findByJobNameAndJobGroupNameAndValid(jobName, jobGroupName, Constants.VALID_TRUE);
        if (ListUtil.isEmpty(scheduledJobEntities).booleanValue()) {
            BaseScheduledTaskEntity baseScheduledTaskEntity = new BaseScheduledTaskEntity();
            baseScheduledTaskEntity.setJobName(jobName);
            baseScheduledTaskEntity.setExeOnce(exeOnce);
            baseScheduledTaskEntity.setJobGroupName(jobGroupName);
            baseScheduledTaskEntity.setJobClassName(jobClass.getName());
            baseScheduledTaskEntity.setCronExpression(cronExpression);
            baseScheduledTaskEntity.setValid(Constants.VALID_TRUE);
            baseScheduledTaskEntity.setParams(params.toJSONString());
            this.baseSchedulerTaskRepository.save(baseScheduledTaskEntity);
        }
        log.info("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u6210\u529f\uff0cjobName\uff1a{}\uff0cjobGroupName\uff1a{}", (Object)jobName, (Object)jobGroupName);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public void deleteJob(String jobName, String jobGroupName) {
        try {
            this.scheduler.pauseTrigger(TriggerKey.triggerKey((String)jobName, (String)jobGroupName));
            this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)jobName, (String)jobGroupName));
            this.scheduler.deleteJob(JobKey.jobKey((String)jobName, (String)jobGroupName));
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff0cjobName\uff1a{}\uff0cjobGroupName\uff1a{}", (Object)jobName, (Object)jobGroupName);
        }
        List<BaseScheduledTaskEntity> scheduledJobEntities = this.baseSchedulerTaskRepository.findByJobNameAndJobGroupNameAndValid(jobName, jobGroupName, Constants.VALID_TRUE);
        if (!CollectionUtils.isEmpty(scheduledJobEntities)) {
            for (BaseScheduledTaskEntity baseScheduledTaskEntity : scheduledJobEntities) {
                baseScheduledTaskEntity.setValid(Constants.VALID_FALSE);
            }
            this.baseSchedulerTaskRepository.saveAll(scheduledJobEntities);
            log.info("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u6210\u529f\uff0cjobName\uff1a{}\uff0cjobGroupName\uff1a{}", (Object)jobName, (Object)jobGroupName);
        }
    }

    @Override
    public void activeJob(String jobName, String jobGroupName) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.add(14, 100);
            String cronExpression = TimeUtil.formatDateByPattern(calendar.getTime(), "ss mm HH dd MM ? yyyy");
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroupName);
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionFireAndProceed();
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            this.scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
            Thread.sleep(300L);
            this.deleteJob(jobName, jobGroupName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6fc0\u6d3b\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff0cjobName\uff1a{}\uff0cjobGroupName\uff1a{}", (Object)jobName, (Object)jobGroupName);
        }
    }

    @Async
    public void run(ApplicationArguments args) throws Exception {
        List scheduledJobEntities = this.baseSchedulerTaskRepository.findByAttr("valid", Constants.VALID_TRUE.toString());
        for (BaseScheduledTaskEntity baseScheduledTaskEntity : scheduledJobEntities) {
            String jobName = baseScheduledTaskEntity.getJobName();
            String jobGroupName = baseScheduledTaskEntity.getJobGroupName();
            String jobClassName = baseScheduledTaskEntity.getJobClassName();
            Boolean exeOnce = baseScheduledTaskEntity.getExeOnce();
            long nowTime = System.currentTimeMillis();
            String paramsString = baseScheduledTaskEntity.getParams();
            String cronExpressionString = baseScheduledTaskEntity.getCronExpression();
            CronExpression cronExpression = new CronExpression(cronExpressionString);
            Date nextDate = cronExpression.getNextValidTimeAfter(new Date());
            if (nextDate == null || nextDate.getTime() <= nowTime) {
                if (exeOnce.booleanValue()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(13, 5);
                    cronExpressionString = TimeUtil.formatDateByPattern(calendar.getTime(), "ss mm HH dd MM ? yyyy");
                } else {
                    this.deleteJob(jobName, jobGroupName);
                    return;
                }
            }
            JSONObject params = JSONObject.parseObject((String)paramsString);
            this.createJob(Class.forName(jobClassName), jobName, jobGroupName, cronExpressionString, params, true);
        }
    }
}

