/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.util;

import com.zx.utils.controller.vo.PageVO;
import java.util.ArrayList;
import java.util.List;
import org.dozer.DozerBeanMapper;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MyBaseConverter {
    private static final Logger log = LoggerFactory.getLogger(MyBaseConverter.class);
    Mapper beanMapper = new DozerBeanMapper();

    public <S, D> D convertSingleObject(S source, Class<D> clazz) {
        if (source == null) {
            return null;
        }
        Object dest = null;
        try {
            dest = this.beanMapper.map(source, clazz);
        }
        catch (Exception var5) {
            log.error("\u521d\u59cb\u5316{}\u5bf9\u8c61\u5931\u8d25\u3002", clazz, (Object)var5);
        }
        return (D)dest;
    }

    public <S, D> List<D> convertMultiObjectToList(List<S> sourceList, Class<D> destClass) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return null;
        }
        ArrayList<D> toList = new ArrayList<D>();
        for (S src : sourceList) {
            toList.add(this.convertSingleObject(src, destClass));
        }
        return toList;
    }

    public <S, D> PageVO<D> convertMultiObjectToMap(Page<S> srcPages, Class<D> destClass) {
        PageVO pageVO = new PageVO();
        ArrayList<D> destList = new ArrayList<D>();
        if (srcPages != null && srcPages.getContent() != null) {
            for (Object src : srcPages.getContent()) {
                destList.add(this.convertSingleObject(src, destClass));
            }
        }
        pageVO.setTotal(srcPages.getTotalElements());
        pageVO.setData(destList);
        pageVO.setPageSize(srcPages.getSize());
        pageVO.setCurrent(srcPages.getNumber() + 1);
        return pageVO;
    }
}

