/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Aspect
@Order(value=-1)
public class LogMethodAspect {
    private static final Logger log = LoggerFactory.getLogger(LogMethodAspect.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Pointcut(value=" @annotation(com.zx.utils.annotation.LogAround)")
    private void logAround() {
    }

    @Around(value="logAround()")
    public Object doAround(ProceedingJoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        String className = signature.getDeclaringTypeName();
        int lastPointIndex = className.lastIndexOf(".");
        className = className.substring(lastPointIndex + 1);
        String methodName = signature.getName();
        Map<String, Object> paramNameAndValue = this.getParamNameAndValue(joinPoint);
        methodName = className + "." + methodName + " ";
        log.info(methodName + "execute before, requestBody: {}", (Object)this.objectMapper.valueToTree(paramNameAndValue));
        Object proceed = null;
        long startTime = System.currentTimeMillis();
        try {
            proceed = joinPoint.proceed();
        }
        catch (Throwable e) {
            log.error(methodName + "execute error, exception: {}", (Object)this.objectMapper.valueToTree((Object)e));
            throw new RuntimeException(e);
        }
        finally {
            log.info(methodName + "execute after, responseBody: {}", (Object)this.objectMapper.valueToTree(proceed));
            log.info(methodName + "execute time: {}", (Object)(System.currentTimeMillis() - startTime + " millisecond"));
        }
        return proceed;
    }

    private Map<String, Object> getParamNameAndValue(ProceedingJoinPoint joinPoint) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        Object[] paramValues = joinPoint.getArgs();
        String[] paramNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        for (int i = 0; i < paramNames.length; ++i) {
            param.put(paramNames[i], paramValues[i]);
        }
        return param;
    }
}

