/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Entity;
import cn.hutool.setting.dialect.Props;
import com.google.common.collect.Lists;
import com.zx.utils.controller.vo.ColumnVO;
import com.zx.utils.controller.vo.GenerateConfigVO;
import com.zx.utils.controller.vo.TableRequestVO;
import com.zx.utils.controller.vo.TableVO;
import com.zx.utils.service.impl.GenerateCodeServiceImpl;
import com.zx.utils.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenerateUtil {
    private static final Logger log = LoggerFactory.getLogger(CodeGenerateUtil.class);
    private static final String ENTITY_JAVA_VM = "Entity";
    private static final String CONFIG_JAVA_VM = "Config";
    private static final String REPOSITORY_JAVA_VM = "Repository";
    private static final String CONTROLLER_JAVA_VM = "Controller";
    private static final String API_JS_VM = "api.ts.vm";
    private static final Pattern PATTERN = Pattern.compile("[^\\\\].*");

    public static void startAutoGenerateCode(String prepend, String url, String tableName, String dataBaseUserName, String password, String author, String moduleName, String packageName, String mainPath) throws SQLException {
        GenerateConfigVO generateConfigVO = new GenerateConfigVO();
        TableRequestVO tableRequestVO = new TableRequestVO();
        tableRequestVO.setPassword(password);
        tableRequestVO.setUsername(dataBaseUserName);
        tableRequestVO.setPrepend(prepend);
        tableRequestVO.setTablename(tableName);
        tableRequestVO.setUrl(url);
        generateConfigVO.setAuthor(author);
        generateConfigVO.setTableName(tableName);
        generateConfigVO.setRequest(tableRequestVO);
        generateConfigVO.setModuleName(moduleName);
        generateConfigVO.setPackageName(packageName);
        generateConfigVO.setMainPath(mainPath);
        new GenerateCodeServiceImpl().generatorCode(generateConfigVO);
    }

    public List<String> getTemplates() {
        return FileUtil.listFile(CodeGenerateUtil.getResourcesFile("template")).stream().map(item -> item.getName()).collect(Collectors.toList());
    }

    public void generatorCode(GenerateConfigVO generateConfigVO, Entity table, List<Entity> columns, ZipOutputStream zip) {
        Props propsDb2Java = new Props();
        Props propssDb2Jdbc = new Props();
        try {
            propsDb2Java.load((InputStream)new ByteArrayInputStream("#\\u4EE3\\u7801\\u751F\\u6210\\u5668\\uFF0C\\u914D\\u7F6E\\u4FE1\\u606F\nmainPath=\n#\\u5305\\u540D\npackage=com.supcon.mare\nmoduleName=tankinfo\n#\\u4F5C\\u8005\nauthor=zhaoxu\n#\\u8868\\u524D\\u7F00(\\u7C7B\\u540D\\u4E0D\\u4F1A\\u5305\\u542B\\u8868\\u524D\\u7F00)\ntablePrefix=tb_\n#\\u7C7B\\u578B\\u8F6C\\u6362\\uFF0C\\u914D\\u7F6E\\u4FE1\\u606F\ntinyint=Integer\nsmallint=Integer\nmediumint=Integer\nint=Integer\ninteger=Integer\nbigint=Long\nfloat=Float\ndouble=Double\ndecimal=BigDecimal\nbit=Boolean\nchar=String\nvarchar=String\nvarchar(255)=String\ntinytext=String\ntext=String\nmediumtext=String\nlongtext=String\ndate=LocalDateTime\ndatetime=LocalDateTime\ncharacter\\u0020varying=String\ntimestamp=LocalDateTime\n".getBytes()));
            propssDb2Jdbc.load((InputStream)new ByteArrayInputStream("tinyint=TINYINT\nsmallint=SMALLINT\nmediumint=MEDIUMINT\nint=INTEGER\ninteger=INTEGER\nbigint=BIGINT\nfloat=FLOAT\ndouble=DOUBLE\ndecimal=DECIMAL\nbit=BIT\nchar=CHAR\nvarchar=VARCHAR\ntinytext=VARCHAR\ntext=VARCHAR\nmediumtext=VARCHAR\nlongtext=VARCHAR\ndate=DATE\ndatetime=DATETIME\ntimestamp=TIMESTAMP\ncharacter\\u0020varying=VARCHAR\nblob=BLOB\nlongblob=LONGBLOB\n".getBytes()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean hasBigDecimal = false;
        TableVO tableEntity = new TableVO();
        tableEntity.setTableName(table.getStr("tableName"));
        if (StrUtil.isNotBlank((CharSequence)generateConfigVO.getComments())) {
            tableEntity.setComments(generateConfigVO.getComments());
        } else {
            tableEntity.setComments(table.getStr("tableComment"));
        }
        String tablePrefix = StrUtil.isNotBlank((CharSequence)generateConfigVO.getTablePrefix()) ? generateConfigVO.getTablePrefix() : propsDb2Java.getStr("tablePrefix");
        String className = this.tableToJava(tableEntity.getTableName(), tablePrefix);
        tableEntity.setCaseClassName(className);
        tableEntity.setLowerClassName(StrUtil.lowerFirst((CharSequence)className));
        ArrayList columnList = Lists.newArrayList();
        String jdbcType = null;
        for (Entity column : columns) {
            ColumnVO columnEntity = new ColumnVO();
            columnEntity.setColumnName(column.getStr("columnName"));
            columnEntity.setDataType(column.getStr("dataType"));
            columnEntity.setComments(column.getStr("columnComment"));
            columnEntity.setExtra(column.getStr("extra"));
            columnEntity.setNullAbled(column.getStr("nullAbled"));
            String attrName = this.columnToJava(columnEntity.getColumnName());
            columnEntity.setCaseAttrName(attrName);
            columnEntity.setLowerAttrName(StrUtil.lowerFirst((CharSequence)attrName));
            String attrType = columnEntity.getDataType().contains("varchar") || columnEntity.getDataType().contains("character") ? "String" : propsDb2Java.getStr(columnEntity.getDataType(), "unknownType");
            columnEntity.setAttrType(attrType);
            jdbcType = columnEntity.getDataType();
            columnEntity.setJdbcType(jdbcType);
            if (!hasBigDecimal && "BigDecimal".equals(attrType)) {
                hasBigDecimal = true;
            }
            if ("PRI".equalsIgnoreCase(column.getStr("columnKey")) && tableEntity.getPk() == null) {
                tableEntity.setPk(columnEntity);
            }
            columnList.add(columnEntity);
        }
        tableEntity.setColumns(columnList);
        if (tableEntity.getPk() == null) {
            tableEntity.setPk(tableEntity.getColumns().get(0));
        }
        Properties prop = new Properties();
        prop.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init((Properties)prop);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("tableName", tableEntity.getTableName());
        map.put("pk", tableEntity.getPk());
        map.put("className", tableEntity.getCaseClassName());
        map.put("classname", tableEntity.getLowerClassName());
        map.put("lowerAttrName", tableEntity.getLowerClassName());
        map.put("pathName", tableEntity.getLowerClassName().toLowerCase());
        map.put("columns", tableEntity.getColumns());
        map.put("hasBigDecimal", hasBigDecimal);
        map.put("datetime", DateUtil.now());
        map.put("year", DateUtil.year((Date)new Date()));
        if (StrUtil.isNotBlank((CharSequence)generateConfigVO.getComments())) {
            map.put("comments", generateConfigVO.getComments());
        } else {
            map.put("comments", tableEntity.getComments());
        }
        if (StrUtil.isNotBlank((CharSequence)generateConfigVO.getAuthor())) {
            map.put("author", generateConfigVO.getAuthor());
        } else {
            map.put("author", propsDb2Java.getStr("author"));
        }
        if (StrUtil.isNotBlank((CharSequence)generateConfigVO.getModuleName())) {
            map.put("moduleName", generateConfigVO.getModuleName());
        } else {
            map.put("moduleName", propsDb2Java.getStr("moduleName"));
        }
        if (StrUtil.isNotBlank((CharSequence)generateConfigVO.getPackageName())) {
            map.put("package", generateConfigVO.getPackageName());
        } else {
            map.put("package", propsDb2Java.getStr("package"));
        }
        if (StrUtil.isNotBlank((CharSequence)generateConfigVO.getMainPath())) {
            map.put("mainPath", generateConfigVO.getMainPath());
        } else {
            map.put("mainPath", propsDb2Java.getStr("mainPath"));
        }
        VelocityContext context = new VelocityContext(map);
        List<String> templates = this.getTemplates();
        for (String template : templates) {
            StringWriter sw = new StringWriter();
            Template tpl = Velocity.getTemplate((String)("template/" + template), (String)"UTF-8");
            tpl.merge((Context)context, (Writer)sw);
            String fileName = this.getFileName(template, tableEntity.getCaseClassName(), map.get("package").toString(), map.get("moduleName").toString());
            try {
                File file;
                Matcher matcher = PATTERN.matcher(fileName);
                String writePath = "";
                if (matcher.find() && !(file = new File(writePath = matcher.group())).exists()) {
                    FileUtil.createFiles(writePath);
                    FileUtil.write(file, sw.toString(), "UTF-8");
                }
                zip.putNextEntry(new ZipEntry(Objects.requireNonNull(fileName)));
                IoUtil.write((OutputStream)zip, (Charset)StandardCharsets.UTF_8, (boolean)false, (Object[])new Object[]{sw.toString()});
                IoUtil.close((Closeable)sw);
                zip.closeEntry();
            }
            catch (IOException e) {
                throw new RuntimeException("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + tableEntity.getTableName(), e);
            }
        }
    }

    private String columnToJava(String columnName) {
        return WordUtils.capitalizeFully((String)columnName, (char[])new char[]{'_'}).replace("_", "");
    }

    private String tableToJava(String tableName, String tablePrefix) {
        if (StrUtil.isNotBlank((CharSequence)tablePrefix)) {
            tableName = tableName.replaceFirst(tablePrefix, "");
        }
        return this.columnToJava(tableName);
    }

    private Props getConfig(String fileName) {
        Props props = new Props(CodeGenerateUtil.getResourcesFile(fileName).getPath());
        props.autoLoad(true);
        return props;
    }

    public static File getResourcesFile(String fileName) {
        try {
            File file = new File(new URI(CodeGenerateUtil.class.getResource("/") + "/" + fileName));
            return file;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getFileName(String template, String className, String packageName, String moduleName) {
        String packagePath = "" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
        String resourcePath = "" + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator;
        String apiPath = "api" + File.separator;
        if (StrUtil.isNotBlank((CharSequence)packageName)) {
            packagePath = packagePath + packageName.replace(".", File.separator) + File.separator + moduleName + File.separator;
        }
        if (template.contains(ENTITY_JAVA_VM)) {
            return packagePath + "entity" + File.separator + className + "Entity.java";
        }
        if (template.contains(CONFIG_JAVA_VM)) {
            return packagePath + "config" + File.separator + template.split("\\.")[0] + ".java";
        }
        if (template.contains(REPOSITORY_JAVA_VM)) {
            return packagePath + "repository" + File.separator + className + "Repository.java";
        }
        if (template.contains(CONTROLLER_JAVA_VM)) {
            return packagePath + "controller" + File.separator + className + "Controller.java";
        }
        if (template.contains(API_JS_VM)) {
            return packagePath + apiPath + className.toLowerCase() + ".ts";
        }
        return null;
    }
}

