/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class RetryMonitor
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(RetryMonitor.class);
    Set<Supplier<?>> retryFunctionSet = new HashSet();
    Map<Supplier<?>, Integer> failedMap = new HashMap(8);
    private final ScheduledExecutorService retryTaskExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("retryTaskExecutor").daemon(true).build());

    public void registryRetry(Supplier<?> retryFunction) {
        this.retryFunctionSet.add(retryFunction);
    }

    public void run(ApplicationArguments args) {
        this.retryTaskExecutor.scheduleAtFixedRate(() -> {
            ArrayList needRemoveFunction = new ArrayList();
            for (Supplier<?> supplier : this.retryFunctionSet) {
                try {
                    supplier.get();
                    needRemoveFunction.add(supplier);
                }
                catch (Exception e) {
                    Integer fieldCount = this.failedMap.get(supplier);
                    fieldCount = fieldCount == null ? 0 : fieldCount + 1;
                    this.failedMap.put(supplier, fieldCount);
                    if (fieldCount > 3) {
                        needRemoveFunction.add(supplier);
                        this.failedMap.remove(supplier);
                    }
                    log.error("\u65b9\u6cd5\uff1a{}\uff0c\u91cd\u8bd5\u7b2c {} \u6b21\u53d1\u751f\u5f02\u5e38\uff0cerrorMessage\uff1a{}", new Object[]{supplier.toString(), fieldCount, e.getMessage()});
                }
            }
            for (Supplier<Object> supplier : needRemoveFunction) {
                this.retryFunctionSet.remove(supplier);
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }
}

