package cn.sylinx.horm.config;

import java.util.Iterator;
import java.util.ServiceLoader;

import cn.sylinx.horm.cache.CacheKitManager;
import cn.sylinx.horm.cache.ICacheKit;
import cn.sylinx.horm.cache.impl.GuavaCacheKit;
import cn.sylinx.horm.util.ClassUtil;
import cn.sylinx.horm.util.GLog;

class CacheLoader {

	private OrmConfig ormConfig;

	CacheLoader(OrmConfig ormConfig) {
		this.ormConfig = ormConfig;
	}

	private ICacheKit loadFromService() {

		try {
			ServiceLoader<ICacheKit> sl = ServiceLoader.load(ICacheKit.class);
			if (sl != null) {
				Iterator<ICacheKit> cacheIt = sl.iterator();
				if (cacheIt.hasNext()) {
					return cacheIt.next();
				}
			}
		} catch (Exception e) {
			GLog.error("cache load from service error", e);
			return null;
		}

		GLog.info("No CacheKit from service loader");
		return null;
	}

	private ICacheKit loadFromDefault() {

		boolean bl = ClassUtil.isClassExist("com.google.common.cache.Cache");
		if (!bl) {
			GLog.error("Guava cache not exist, please confirm");
			return null;
		}

		return new GuavaCacheKit(ormConfig.getGuavaCacheConfig());
	}

	void initCache() {

		// 首先从service loader 取
		ICacheKit cacheKit = loadFromService();
		if (cacheKit == null) {
			cacheKit = loadFromDefault();
		}

		if (cacheKit == null) {
			GLog.info("No Suitable CacheKit");
			ormConfig.setCache(false);
			return;
		}

		CacheKitManager.set(cacheKit);
		GLog.info("Cache inited, use {}", cacheKit.getClass().getName());
	}
}
