package cn.sylinx.horm.config;

import cn.sylinx.horm.model.cache.ModelConst;
import cn.sylinx.horm.model.strategy.Strategy;
import cn.sylinx.horm.util.StrKit;

/**
 * 模型映射策略加载
 * 
 * @author johnhan
 *
 */
class MapStrategyLoader {

	private OrmConfig ormConfig;

	MapStrategyLoader(OrmConfig ormConfig) {
		this.ormConfig = ormConfig;
	}

	void load() {

		String strategy = ormConfig.getModelMapStrategy();
		if (StrKit.isBlank(strategy)) {
			strategy = Strategy.STRATEGY_UNDERLINE;
		}

		String strategyClass = Strategy.STRATEGY_CLZ_UNDERLINE;

		if (strategy.equals(Strategy.STRATEGY_ATTRIBUTE)) {
			strategyClass = Strategy.STRATEGY_CLZ_ATTRIBUTE;
		} else if (strategy.equals(Strategy.STRATEGY_UNDERLINE)) {
			strategyClass = Strategy.STRATEGY_CLZ_UNDERLINE;
		}

		ModelConst.ME.setMappingStrategy(strategyClass);
	}
}
