package cn.sylinx.horm.config;

import java.util.ArrayList;
import java.util.List;

import cn.sylinx.horm.proxy.mapper.registrar.MapperRegistrar;
import cn.sylinx.horm.util.StrKit;

class MapperLoader {

	private OrmConfig ormConfig;

	MapperLoader(OrmConfig ormConfig) {
		this.ormConfig = ormConfig;
	}

	public void load() {
		// Mapper 扫描包，如果为空，则全项目扫描
		String mapperScanPackage = ormConfig.getMapperScanPackage();
		String mapperPostfix = ormConfig.getMapperPostfix();
		if(StrKit.isBlank(mapperPostfix)) {
			mapperPostfix = OrmConfig.DEFAULT_MAPPER_POST_FIX;
		}
		
		List<String> pkgs = new ArrayList<>();
		if (StrKit.isBlank(mapperScanPackage)) {
			pkgs.add("");
		} else {
			String[] splitPkg = mapperScanPackage.split(",");
			for (int i = 0; i < splitPkg.length; ++i) {
				if (!StrKit.isBlank(splitPkg[i])) {
					pkgs.add(splitPkg[i]);
				}
			}
		}

		for (String pkg : pkgs) {
			MapperRegistrar.create().register(pkg, mapperPostfix);
		}
	}

}
