package cn.sylinx.horm.config;

import cn.sylinx.horm.core.interceptor.SqlClientInterceptor;
import cn.sylinx.horm.util.ClassUtil;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;

class SqlClientInterceptorLoader {

	private OrmConfig ormConfig;

	SqlClientInterceptorLoader(OrmConfig ormConfig) {
		this.ormConfig = ormConfig;
	}

	public SqlClientInterceptor load() {

		String interceptorClass = ormConfig.getInterceptorClass();
		if (StrKit.isNotBlank(interceptorClass)) {
			try {
				Class<?> clz = Class.forName(interceptorClass, false, ClassUtil.getDefaultClassLoader());
				GLog.info("load SqlClient Interceptor: {}", interceptorClass);
				return (SqlClientInterceptor) clz.newInstance();
			} catch (Exception e) {
				GLog.error("interceptor load error", e);
			}
		}
		GLog.info("NO SqlClient Interceptor loaded");
		return null;
	}
}
