package cn.sylinx.horm.core;

import java.util.Iterator;
import java.util.ServiceLoader;

import cn.sylinx.horm.core.common.PreparedCallWrapper;
import cn.sylinx.horm.core.common.PreparedCallable;

enum PreparedCallWrapperManager {

	;

	private static PreparedCallWrapper callWrapper = null;

	static PreparedCallWrapper getCallWrapper() {

		if (callWrapper != null) {
			return callWrapper;
		}

		synchronized (PreparedCallWrapperManager.class) {

			if (callWrapper != null) {
				return callWrapper;
			}

			ServiceLoader<PreparedCallWrapper> sl = ServiceLoader.load(PreparedCallWrapper.class);
			if (sl != null) {
				Iterator<PreparedCallWrapper> it = sl.iterator();
				if (it != null && it.hasNext()) {
					callWrapper = it.next();
				}
			}

			if (callWrapper == null) {

				// 未设置，什么都不做
				callWrapper = new PreparedCallWrapper() {
					@Override
					public <T> PreparedCallable<T> wrap(PreparedCallable<T> preparedCallable) {
						return preparedCallable;
					}
				};
			}
		}

		return callWrapper;
	}
}
