package cn.sylinx.horm.core.common;

import java.io.Serializable;
import java.util.List;

@SuppressWarnings("serial")
public class Page<T> implements Serializable {

	private List<T> list; // list result of this page
	private int pageNumber; // page number
	private int pageSize; // result amount of this page
	private int totalPage; // total page
	private int totalRow; // total row

	public Page() {
	}

	/**
	 * Constructor.
	 * 
	 * @param list
	 *            the list of paginate result
	 * @param pageNumber
	 *            the page number
	 * @param pageSize
	 *            the page size
	 * @param totalPage
	 *            the total page of paginate
	 * @param totalRow
	 *            the total row of paginate
	 */
	public Page(List<T> list, int pageNumber, int pageSize, int totalPage, int totalRow) {
		this.list = list;
		this.pageNumber = pageNumber;
		this.pageSize = pageSize;
		this.totalPage = totalPage;
		this.totalRow = totalRow;
	}

	public boolean isEmpty() {
		return list == null || list.isEmpty();
	}

	/**
	 * Return list of this page.
	 */
	public List<T> getList() {
		return list;
	}

	/**
	 * Return page number.
	 */
	public int getPageNumber() {
		return pageNumber;
	}

	/**
	 * Return page size.
	 */
	public int getPageSize() {
		return pageSize;
	}

	/**
	 * Return total page.
	 */
	public int getTotalPage() {
		return totalPage;
	}

	/**
	 * Return total row.
	 */
	public int getTotalRow() {
		return totalRow;
	}

	/**
	 * set the data list
	 * 
	 * @param list
	 *            the data list
	 * @return Page object
	 */
	public Page<T> setList(List<T> list) {
		this.list = list;
		return this;
	}

	/**
	 * set the page number
	 * 
	 * @param pageNumber
	 *            the page number
	 * @return Page object
	 */
	public Page<T> setPageNumber(int pageNumber) {
		this.pageNumber = pageNumber;
		return this;
	}

	/**
	 * set the page size
	 * 
	 * @param pageSize
	 *            the page size
	 * @return Page object
	 */
	public Page<T> setPageSize(int pageSize) {
		this.pageSize = pageSize;
		return this;
	}

	/**
	 * set the total page
	 * 
	 * @param totalPage
	 *            the total page
	 * @return Page object
	 */
	public Page<T> setTotalPage(int totalPage) {
		this.totalPage = totalPage;
		return this;
	}

	/**
	 * set the total row count
	 * 
	 * @param totalRow
	 *            the total row count
	 * @return Page object
	 */
	public Page<T> setTotalRow(int totalRow) {
		this.totalRow = totalRow;
		return this;
	}

	@Override
	public String toString() {
		return "Page [list=" + list + ", pageNumber=" + pageNumber + ", pageSize=" + pageSize + ", totalPage="
				+ totalPage + ", totalRow=" + totalRow + "]";
	}
	
}