package cn.sylinx.horm.core.stat;

import cn.sylinx.horm.config.OrmConfigHolder;

/**
 * SQL运行时长线程状态维护者
 * 
 * @author johnhan
 *
 */
public enum SqlStatManager {

	;

	private static SqlStatExecutor sqlStatExecutor;

	public static synchronized void start() {

		if (!OrmConfigHolder.isSqlStatOpen()) {
			return;
		}

		if (sqlStatExecutor == null) {
			sqlStatExecutor = new SqlStatExecutor();
		}

		sqlStatExecutor.start();
	}

	public static synchronized void stop() {

		if (!OrmConfigHolder.isSqlStatOpen()) {
			return;
		}

		if (sqlStatExecutor == null) {
			return;
		}
		sqlStatExecutor.stop();
	}

	static void receiveSql(String type, String seq, String datasoureName, String nativeSql, Long time,
			Throwable error) {
		
		if (!OrmConfigHolder.isSqlStatOpen()) {
			return;
		}
		
		if (sqlStatExecutor == null) {
			return;
		}

		if (sqlStatExecutor.isStarted()) {
			sqlStatExecutor.receiveSql(type, seq, datasoureName, nativeSql, time, error);
		}
	}
}
