package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;

class SqlserverFSBuilder implements FSBuilder {

	@Override
	public <T> FS<T> build(Class<T> modelClass) {
		return SqlserverFS.of(modelClass);
	}

	@Override
	public <T> FS<T> build(Class<T> modelClass, String tablePostfix) {
		return SqlserverFS.of(modelClass, tablePostfix);
	}

	@Override
	public <T> FS<T> build(String tablePrefix, Class<T> modelClass) {
		return SqlserverFS.of(tablePrefix, modelClass);
	}

	@Override
	public <T> FS<T> build(String tablePrefix, Class<T> modelClass, String tablePostfix) {
		return SqlserverFS.of(tablePrefix, modelClass, tablePostfix);
	}

}
