package cn.sylinx.horm.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Invocation {

	private final Object target;
	private final Method method;
	private final Object[] args;

	public Invocation(Object target, Method method, Object[] args) {
		this.target = target;
		this.method = method;
		this.args = args;
	}

	public Object getTarget() {
		return target;
	}

	public Method getMethod() {
		return method;
	}

	public Object[] getArgs() {
		return args;
	}

	public Object proceed() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
		return method.invoke(target, args);
	}

	@Override
	public String toString() {
		return "Invocation [target=" + target + ", method=" + method + ", args=" + Arrays.toString(args) + "]";
	}

	
}
