package cn.sylinx.horm.proxy.command.invoker;

import java.util.Map;

import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.proxy.command.CommandMethodMetadata;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.util.Tuple;

class RecordQueryOneCommandInvoker extends AbstractCommandInvoker {

	@Override
	public Object invoke(CommandMethodMetadata methodMetadata, Tuple tuple) {

		Map<String, Object> params = tuple.getObject(0);
		String truelyDatasource = tuple.getObject(3);
		String nativeSql = methodMetadata.getResource().nativeSql();
		String sql = methodMetadata.getResource().sql();
		SqlClient ormClient = getClient(truelyDatasource);

		// 使用native sql
		boolean isNativeSql = nativeSql != null && !"".equals(nativeSql.trim());
		if (isNativeSql) {
			Tuple t = ormClient.getSqlParser().parseSql(nativeSql, params, null);
			String truelyNativeSql = t.getObject(0);
			Object[] truelyParams = t.getObject(1);
			return ormClient.queryRecord(truelyNativeSql, truelyParams);
		}

		return ormClient.queryRecord(new ClasspathSqlResource(sql), params);
	}
}