
package cn.sylinx.horm.resource.ast;

interface Tags {

    String KW_IF = "#IF";
    String KW_ELSIF = "#ELSIF";
    String KW_ELSE = "#ELSE";
    String KW_END = "#END";
    String KW_FUNC = "#FUNC";

    // 条件符号
    String TOKEN_CON_END = "]";
    String VAR_PREFIX = "#{";

    /**
     * 是否接近关键词
     * 
     * @param kw
     * @return
     */
    static boolean isSeeminglyKeyworld(String kw) {

        if (Tags.KW_IF.startsWith(kw) || Tags.KW_ELSIF.startsWith(kw) || Tags.KW_ELSE.startsWith(kw) || Tags.KW_END.startsWith(kw)
                || Tags.KW_FUNC.startsWith(kw) || Tags.VAR_PREFIX.startsWith(kw)) {
            return true;
        }

        return false;
    }
}
